/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.withdraw.strategy;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.util.NidGeneratorUtil;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.param.AccountCashParam;
import com.bxm.localnews.payment.config.WithdrawProperties;
import com.bxm.localnews.payment.constant.WithdrawEnum;
import com.bxm.localnews.payment.constant.WithdrawTypeEnum;
import com.bxm.localnews.payment.domain.WithdrawMapper;
import com.bxm.localnews.payment.pay.WithdrawProxySerivce;
import com.bxm.localnews.payment.vo.WithdrawFlow;
import com.bxm.localnews.payment.withdraw.IWithdrawStrategy;
import com.bxm.localnews.payment.withdraw.WithdrawContext;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractWithdrawStrategy
implements IWithdrawStrategy {
    @Autowired
    protected WithdrawMapper withdrawMapper;
    @Autowired
    protected WithdrawProperties withdrawProperties;
    @Autowired
    protected UserAccountIntegrationService userAccountIntegrationService;
    @Autowired
    protected SequenceCreater sequenceCreater;
    @Autowired
    protected WithdrawProxySerivce withdrawProxySerivce;

    protected Message directWithdraw(WithdrawContext context) {
        WithdrawFlow withdrawFlow = this.buildWithdraw(context);
        withdrawFlow.setState(WithdrawEnum.DURING_PAYMENT.getState());
        this.withdrawMapper.addWithdrawFlow(withdrawFlow);
        Message message = this.userAccountIntegrationService.updateUserWithdraw(context.getUserId(), context.getAmount(), WithdrawEnum.DURING_PAYMENT.getState());
        if (message.isSuccess()) {
            return this.withdrawProxySerivce.withdraw(withdrawFlow);
        }
        return message;
    }

    protected void afterThirdpartyPay(WithdrawContext context, WithdrawFlow withdrawFlow, boolean success, String reason) {
        WithdrawFlow update = new WithdrawFlow();
        update.setId(withdrawFlow.getId());
        if (success) {
            update.setState(WithdrawEnum.SUCCESS_PAYMENT.getState());
            this.userAccountIntegrationService.updateUserWithdraw(context.getUserId(), context.getAmount(), WithdrawEnum.SUCCESS_PAYMENT.getState());
        } else {
            update.setState(WithdrawEnum.FAIL_PAYMENT.getState());
            update.setRemark(reason);
            this.userAccountIntegrationService.updateUserWithdraw(context.getUserId(), context.getAmount(), WithdrawEnum.FAIL_PAYMENT.getState());
        }
        this.withdrawMapper.updateWithdrawFlow(update);
    }

    protected Message submitApprove(WithdrawContext context) {
        WithdrawFlow withdrawFlow = this.buildWithdraw(context);
        int result = this.withdrawMapper.addWithdrawFlow(withdrawFlow);
        this.updateUserAccount(context);
        return Message.build((int)result);
    }

    protected void updateUserAccount(WithdrawContext context) {
        AccountCashParam accountCashParam = new AccountCashParam(context.getUserId(), "DRAWABLEL_CASH", Boolean.FALSE, context.getAmount(), context.getWithDrawId(), Objects.equals(WithdrawTypeEnum.ALI_WITHDRAW, context.getWithdrawType()) ? "ALIPAY_WITHDRAWAL" : "WECHAT_WITHDRAWAL", null);
        this.userAccountIntegrationService.addCash(accountCashParam);
    }

    protected WithdrawFlow buildWithdraw(WithdrawContext context) {
        WithdrawFlow withdrawFlow = new WithdrawFlow();
        withdrawFlow.setId(this.sequenceCreater.nextLongId());
        withdrawFlow.setOrderNo(this.generateWithdrawNum());
        withdrawFlow.setPayChannel(Objects.isNull(context.getWithdrawType()) ? WithdrawTypeEnum.WX_WITHDRAW.getId() : context.getWithdrawType().getId());
        withdrawFlow.setUserId(context.getUserId());
        withdrawFlow.setPayAccount(context.getWithdrawAccount());
        withdrawFlow.setState(WithdrawEnum.AUDIT.getState());
        if (context.isRisk()) {
            withdrawFlow.setState(WithdrawEnum.DELAY_AUDIT.getState());
        }
        withdrawFlow.setAmount(context.getAmount());
        withdrawFlow.setRealName(context.getRealName());
        withdrawFlow.setClientIp(context.getOriginParam().getRequestIp());
        withdrawFlow.setEquipment(context.getOriginParam().getDevcId());
        Date now = new Date();
        withdrawFlow.setCreateTime(now);
        withdrawFlow.setUpdateTime(now);
        if (Objects.equals(PlatformEnum.APPLET.getCode(), context.getOriginParam().getPlatform())) {
            withdrawFlow.setWithdrawType(Byte.valueOf("2"));
        } else {
            withdrawFlow.setWithdrawType(Byte.valueOf("1"));
        }
        context.setWithDrawId(withdrawFlow.getId());
        return withdrawFlow;
    }

    protected String generateWithdrawNum() {
        String prefix = WithdrawTypeEnum.getNameByType((Byte)WithdrawTypeEnum.WX_WITHDRAW.getType());
        return NidGeneratorUtil.getOrderNo((String)prefix);
    }
}

