/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.withdraw.strategy;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.payment.WithdrwaStrategyEnum;
import com.bxm.localnews.payment.withdraw.WithdrawContext;
import com.bxm.localnews.payment.withdraw.strategy.AbstractWithdrawStrategy;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OnceApproveWithdrawStrategy
extends AbstractWithdrawStrategy {
    private final RedisSetAdapter redisSetAdapter;

    @Autowired
    public OnceApproveWithdrawStrategy(RedisSetAdapter redisSetAdapter) {
        this.redisSetAdapter = redisSetAdapter;
    }

    @Override
    public WithdrwaStrategyEnum match() {
        return WithdrwaStrategyEnum.ONCE_APPROVE;
    }

    private KeyGenerator buildKey(Long userId) {
        return RedisConfig.WITHDRAW_ONCE_APPROVE_RECORD.copy().appendKey((Object)(userId % 10L));
    }

    @Override
    public Message execWithdraw(WithdrawContext context) {
        Message message = this.submitApprove(context);
        if (message.isSuccess()) {
            this.redisSetAdapter.add(this.buildKey(context.getUserId()), new Object[]{context.getUserId()});
        }
        return message;
    }

    @Override
    public boolean hasTimes(Long userId) {
        return this.redisSetAdapter.exists(this.buildKey(userId), (Object)userId) == false;
    }
}

