package com.bxm.localnews.quartz.domain;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Mapper
public interface InviteRelationshipMapper {

    /**
     * 获取邀请赏金
     *
     * @param inviteUserId
     * @param invitedUserId
     * @return
     */
    List<Map<String, Object>> getIdAndInvitedAward(@Param("userId") Long inviteUserId, @Param("invitedUserId") Long invitedUserId);

    /**
     * 获取账户临时金额
     *
     * @param userId
     * @return
     */
    BigDecimal getAccountTempCash(@Param("userId") Long userId);

    /**
     * 邀请关系失效
     *
     * @param userId
     * @param invitedUserId
     * @return
     */
    Boolean removeInviteRecord(@Param("userId") Long userId, @Param("invitedUserId") Long invitedUserId);

    /**
     * 移除用户表的邀请人id
     *
     * @param userId
     * @return
     */
    Boolean removeUserInvite(@Param("userId") Long userId);

    /**
     * 更新用户为可领取红包状态
     * @param userId 用户id
     * @return 更新结果
     */
    int updateReceiveRedPacket(@Param("userId") Long userId);


}
