package com.bxm.localnews.quartz.domain;

import com.bxm.localnews.quartz.vo.News;
import com.bxm.localnews.quartz.vo.NewsSearchWordBean;
import com.bxm.localnews.quartz.vo.RecommendNewsBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface NewsQuartzMapper {

    /**
     * 删除搜索热词记录
     */
    void delete();

    /**
     * 批量新增搜索热词记录
     * @param words 搜索热词
     */
    void insertBatch(@Param("list") List<NewsSearchWordBean> words);

    /**
     * 获取给用户推荐的新闻信息，用于唤醒沉默用户
     * @return 推荐的新闻列表，与用户一对一
     */
    List<RecommendNewsBean> noticeRecommendNewsList(Long id);

    List<News> listForPublish(@Param("status") Byte status);

    int updateStatusById(@Param("id") Long id, @Param("status") Byte status);

    Integer updateLevelById(@Param("id") Long id, @Param("showLevel") Integer showLevel, @Param("showLevelDetail") String showLevelDetail);

    List<News> getExpireHotList(@Param("showLevel") Integer showLevel);
}