package com.bxm.localnews.quartz.domain;


import com.bxm.localnews.quartz.vo.RedPacket;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

@Mapper
/**
 * 红包数据接口层
 * @author Dong_hy
 */
public interface RedPacketMapper {


    /**
     * 条件更新红包数据
     * @param redPacket 数据
     * @return 更新结果
     */
    int updateByPrimaryKeySelective(RedPacket redPacket);

    /**
     * 获取需要推送的红包(1.红包有人领取,2.红包没有被领完,3.红包还处于上线状态,4.推送审核通过后第二天11点的红包)
     * @return 查询结果
     */
    List<RedPacket> queryPushList();

    /**
     * 更新push推送的标志位
     * @param id 红包id
     * @return 更新结果
     */
    int updatePushFlag(Long id);

}