package com.bxm.localnews.quartz.domain;

import java.math.BigDecimal;
import java.util.List;

import com.bxm.localnews.quartz.vo.WithdrawFlow;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * @author zhaoyadong 2019/3/29 14:57
 * @desc
 */
@Mapper
public interface WithdrawMapper {

    List<WithdrawFlow> queryWithdraw();

    /**
     * 统计时间段内的提现总额
     *
     * @param startTime
     * @param endTime
     * @return
     */
    BigDecimal countWithdrawAmount(@Param("startTime") String startTime, @Param("endTime") String endTime);

    /**
     * 统计时间段内的成功提现总额
     *
     * @param startTime
     * @param endTime
     * @return
     */
    BigDecimal countSuccessWithdrawAmount(@Param("startTime") String startTime, @Param("endTime") String endTime);

    /**
     * 统计对应时间段内的提现人数
     *
     * @param startTime
     * @param endTime
     * @return
     */
    int countNumber(@Param("startTime") String startTime, @Param("endTime") String endTime);
}
