/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.quartz.runtime;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.quartz.domain.NewsMonitorMapper;
import com.bxm.localnews.quartz.facade.DingtalkPushService;
import com.bxm.localnews.quartz.integration.NewsIntegrationService;
import com.bxm.localnews.quartz.param.MonitorTaskBuildParam;
import com.bxm.localnews.quartz.runtime.AbstractRuntimeJob;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsMonitorTask
extends AbstractRuntimeJob {
    @Autowired
    private NewsMonitorMapper newsMonitorMapper;
    @Autowired
    private DingtalkPushService dingtalkPushService;
    @Autowired
    private NewsIntegrationService newsIntegrationService;

    public NewsMonitorTask() {
        super("NewsMonitorTask", "once");
        super.setCount(0);
    }

    @Override
    public Message run() {
        Map paramMap = this.getParam();
        if (null != paramMap) {
            MonitorTaskBuildParam param = (MonitorTaskBuildParam)this.getParam().get("parameter");
            this.logger.warn("\u65b0\u95fb\u76d1\u63a7\u6267\u884c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
            if (null == param || null == param.getIndexId() || null == param.getMonitorId() || param.getNum() == null) {
                return Message.build((boolean)false).setMessage("\u65b0\u95fb\u76d1\u63a7ID\u4e3a\u7a7a\uff0c\u76d1\u63a7\u6307\u6807\u4e3a\u7a7a");
            }
            Date startTime = new Date();
            startTime = DateUtils.clearTimePart((Date)startTime);
            Date endTime = DateUtils.addField((Date)startTime, (int)11, (int)NumberUtils.parseToInt((String)param.getFireTime()));
            param.setStartTime(DateUtils.formatDateTime((Date)startTime));
            param.setEndTime(DateUtils.formatDateTime((Date)endTime));
            if (0 == param.getKindId()) {
                param.setKindId(null);
            }
            if (StringUtils.isNotBlank((CharSequence)param.getAreaCodes())) {
                String[] areaArray;
                for (String areaCode : areaArray = StringUtils.split((String)param.getAreaCodes(), (String)",")) {
                    param.setAreaCode(areaCode);
                    this.logger.warn("\u65b0\u95fb\u76d1\u63a7\u6267\u884c\u53c2\u6570[\u589e\u52a0\u65f6\u95f4\u533a\u95f4]\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
                    this.sendMsg(this.newsIntegrationService.countNews(param), areaCode);
                }
            } else {
                this.sendMsg(this.newsIntegrationService.countNews(param), null);
            }
        }
        return Message.build((boolean)false).setMessage("\u65b0\u95fb\u76d1\u63a7\u4efb\u52a1\u8c03\u5ea6\u5931\u8d25\uff0c\u7f3a\u5c11\u53c2\u6570\u6ce8\u5165");
    }

    private void sendMsg(int total, String areaCode) {
        MonitorTaskBuildParam param = (MonitorTaskBuildParam)this.getParam().get("parameter");
        if (total < param.getNum()) {
            String content = "\u76d1\u63a7\u6307\u6807[" + param.getName() + "]\u5f02\u5e38\uff0c\u8981\u6c42\u65b0\u95fb\u6570\u91cf:[" + param.getNum() + "],\u5b9e\u9645\u6570\u91cf:[" + total + "]";
            if (areaCode != null) {
                content = content + "\uff0c\u76d1\u63a7\u533a\u57df\uff1a[" + this.newsMonitorMapper.getAreaName(areaCode) + "]";
            }
            this.dingtalkPushService.push(content);
            this.newsIntegrationService.updateMonitorStatus(param.getMonitorId(), 1, content);
        } else {
            this.newsIntegrationService.updateMonitorStatus(param.getMonitorId(), 0, null);
        }
    }
}

