/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.quartz.runtime;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.quartz.constant.PushMessageStatusEnum;
import com.bxm.localnews.quartz.domain.AdminPushMessageMapper;
import com.bxm.localnews.quartz.facade.PushMsgIntegService;
import com.bxm.localnews.quartz.param.PushMsgBuildParam;
import com.bxm.localnews.quartz.runtime.AbstractRuntimeJob;
import com.bxm.newidea.component.vo.Message;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PushMessageTask
extends AbstractRuntimeJob {
    @Autowired
    private AdminPushMessageMapper adminPushMessageMapper;
    @Autowired
    private PushMsgIntegService pushMsgIntegService;

    public PushMessageTask() {
        super("pushMessageTask", "once");
        super.setCount(0);
    }

    @Override
    protected Message run() {
        this.logger.debug("\u5b9a\u65f6\u63a8\u9001\u5f00\u59cb\u6267\u884c:", (Object)JSON.toJSONString((Object)((Object)this)));
        Map paramMap = this.getParam();
        if (null != paramMap) {
            PushMsgBuildParam pushMsgBuildParam = (PushMsgBuildParam)paramMap.get("parameter");
            Long messageId = pushMsgBuildParam.getMessageId();
            PushMessage pushMessage = pushMsgBuildParam.getPushMessage();
            int status = this.adminPushMessageMapper.selectByPrimaryKey(messageId);
            if (PushMessageStatusEnum.STAY_CONFIRM.getType().equals(status)) {
                this.logger.warn("\u6d88\u606fID[{}]\u5df2\u53d6\u6d88\u63a8\u9001", (Object)messageId);
                return Message.build((boolean)false).setMessage("\u6d88\u606fID[" + messageId + "]\u5df2\u53d6\u6d88\u63a8\u9001");
            }
            if (PushMessageStatusEnum.BEING_SEND.getType().equals(status)) {
                this.logger.warn("\u6d88\u606fID[{}]\u6b63\u5728\u63a8\u9001\u4e2d", (Object)messageId);
                return Message.build((boolean)false).setMessage("\u6d88\u606fID[" + messageId + "]\u6b63\u5728\u63a8\u9001\u4e2d");
            }
            if (PushMessageStatusEnum.HAS_BEEN_SEND.getType().equals(status)) {
                return Message.build((boolean)false).setMessage("\u6d88\u606fID[" + messageId + "]\u5df2\u5b8c\u6210\u63a8\u9001");
            }
            this.logger.debug("\u6267\u884c\u6d88\u606f\u63a8\u9001,\u63a8\u9001\u6d88\u606fID:[{}],\u63a8\u9001\u6d88\u606f\u5bf9\u8c61\uff1a[{}]", (Object)messageId, (Object)pushMessage);
            this.adminPushMessageMapper.updatePushMessageStatus(messageId, PushMessageStatusEnum.BEING_SEND.getType());
            this.pushMsgIntegService.pushMsg(pushMessage);
            return Message.build((boolean)true);
        }
        return Message.build((boolean)false).setMessage("\u6d88\u606f\u63a8\u9001\u4efb\u52a1\u8c03\u5ea6\u5931\u8d25\uff0c\u7f3a\u5c11\u53c2\u6570\u6ce8\u5165");
    }
}

