/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.quartz.temp;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.quartz.config.DingtalkProperties;
import com.bxm.localnews.quartz.domain.UserStatisticsMapper;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.inner.IntervalMap;
import com.bxm.newidea.component.vo.Message;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class RegStatisticsTask
extends AbstractCustomJob {
    @Resource
    private DingtalkProperties dingtalkProperties;
    @Resource
    private HttpClientService httpClientService;
    @Resource
    private UserStatisticsMapper userStatisticsMapper;

    public RegStatisticsTask() {
        super("regStaticsTask", "calculate", "0 0 9 * * ?", "\u6bcf\u65e5\u65e9\u4e0a9\u70b9\u7edf\u8ba1\u5e7f\u5fb7\u548c\u5bcc\u9633\u7684\u6ce8\u518c\u4eba\u6570\u548cVIP\u4eba\u6570");
    }

    public Message service() {
        IntervalMap intervalMap = DateUtils.getInterval((DateUtils.Interval)DateUtils.Interval.YESTERDAY);
        List regUserList = this.userStatisticsMapper.regUser(intervalMap.getStartTime(), intervalMap.getEndTime());
        List vipUserList = this.userStatisticsMapper.vipUser(intervalMap.getStartTime(), intervalMap.getEndTime());
        StringBuilder content = new StringBuilder();
        content.append("\u6628\u65e5App\u5185\u65b0\u6ce8\u518c\u7528\u6237\uff1a[\n");
        int sum = 0;
        for (Map areaGroup : regUserList) {
            String total = areaGroup.get("total") + "";
            sum += NumberUtils.parseToInt((String)total);
            content.append(areaGroup.get("name")).append("[").append(total).append("]\u4eba\n");
        }
        content.append("]\u3002\u5171\uff1a[").append(sum).append("]\n");
        content.append("VIP\u6fc0\u6d3b\u60c5\u51b5\uff1a[\n");
        for (Map vipGroup : vipUserList) {
            content.append(vipGroup.get("name")).append("-").append(vipGroup.get("total")).append("\n");
        }
        content.append("]\u3002");
        JSONObject text = new JSONObject();
        text.put("content", (Object)content);
        JSONObject msg = new JSONObject();
        msg.put("msgtype", (Object)"text");
        msg.put("text", (Object)text);
        String response = this.httpClientService.doPostJson(this.dingtalkProperties.getRegStatisticsWebhook(), msg.toJSONString());
        this.logger.debug("dingding response:{}", (Object)response);
        return Message.build((boolean)true);
    }
}

