package com.bxm.localnews.quartz.runtime;

import com.bxm.newidea.cloud.constant.EnvConstant;
import com.bxm.newidea.cloud.ribbon.RibbonFilterContextHolder;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;

import java.util.Map;

/**
 * 为预发做准备的job类
 */
public abstract class AbstractRuntimeJob extends AbstractCustomJob {

    public AbstractRuntimeJob(String jobName, String cron, String description) {
        super(jobName, cron, description);
        setVar();
    }

    public AbstractRuntimeJob(String jobName, String group, String cron, String description) {
        super(jobName, group, cron, description);
        setVar();
    }

    public AbstractRuntimeJob(String jobName, String group) {
        super(jobName, group);
        setVar();
    }

    public AbstractRuntimeJob(String jobName, String group, String cron, String description, int priority, Map<String, Object> param) {
        super(jobName, group, cron, description, priority, param);
        setVar();
    }

    private void setVar() {
        String env = RibbonFilterContextHolder.getCurrentContext().get(EnvConstant.ENV_HEADER_KEY);
        if (StringUtils.isNotBlank(env)) {
            RibbonFilterContextHolder.clearCurrentContext();
            RibbonFilterContextHolder.getCurrentContext().add(EnvConstant.ENV_HEADER_KEY, EnvConstant.PRE_ENV_VALUE);
            this.addParam(EnvConstant.ENV_HEADER_KEY, env);
        }
    }

    @Override
    protected Message service() {
        //在任务执行时从data中取出预发环境变量，如果存在则继续传递预发环境变量
        Map<String,Object> properties = this.getParam();
        if (properties!=null) {
            String env = (String) properties.get(EnvConstant.ENV_HEADER_KEY);
            if (StringUtils.isNotBlank(env)) {
                RibbonFilterContextHolder.clearCurrentContext();
                RibbonFilterContextHolder.getCurrentContext().add(EnvConstant.ENV_HEADER_KEY, EnvConstant.PRE_ENV_VALUE);
            }
        }
        return run();
    }

    /**
     * 每个任务实现run方法
     * @return
     */
    protected abstract Message run();
}
