package com.bxm.localnews.quartz.runtime;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.integration.NewsIntegrationService;
import com.bxm.localnews.quartz.param.AddPostClickCountParam;
import com.bxm.newidea.component.quartz.service.ScheduleJobService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.Map;
import java.util.Random;

@Component
public class AddPostClickCountTask extends AbstractRuntimeJob {
    private static final long ONE_DAY = 24 * 3600000L;
    private static final long THREE_HOUR = 3 * 3600000L;

    @Resource
    private NewsIntegrationService newsIntegrationService;

    @Resource
    private ScheduleJobService scheduleJobService;

    public AddPostClickCountTask() {
        super("addPostClickCountTask", TaskGroup.ONCE);
        super.setCount(0);
    }

    @Override
    protected Message run() {
        logger.debug("定时增加帖子点击数开始执行:", JSON.toJSONString(this));
        Map<String, Object> paramMap = this.getParam();

        if (null == paramMap) {
            return Message.build(false).setMessage("定时增加帖子点击数任务调度失败，缺少参数注入");
        }

        AddPostClickCountParam param = (AddPostClickCountParam) paramMap.get("parameter");
        logger.info("定时增加帖子点击数任务参数：{}", JSONObject.toJSONString(param));

        if (null != param) {
            scheduleJobService.remove(this.getJobName() + "_" + param.getPostId(), this.getGroup());
            return Message.build(true);
        }
//
//        if (param.getClickCount() < 1500L) {
//            scheduleJobService.remove(this.getJobName(), this.getGroup());
//            return Message.build(false).setMessage("增加的点击数小于基础值");
//        }
//
//        long executeTime = new Date().getTime() - param.getStartTime().getTime();
//        if (executeTime >= ONE_DAY) {
//            scheduleJobService.remove(this.getJobName(), this.getGroup());
//            return Message.build(true);
//        }
//
//        long addPostClick;
//        if (executeTime < THREE_HOUR) {
//            //未增加至基础值
//            addPostClick = 20L + new Random().nextInt(10);
//        } else {
//            //未增加至指定值
//            addPostClick = (param.getClickCount() - 1500L) / 420L;
//        }
//        newsIntegrationService.addPostClick(param.getPostId(), addPostClick);

        return Message.build(true);
    }

}
