package com.bxm.localnews.quartz.runtime;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.domain.InviteRelationshipMapper;
import com.bxm.localnews.quartz.facade.UserAccountIntegService;
import com.bxm.localnews.quartz.param.AccountCashParam;
import com.bxm.localnews.quartz.param.InviteExpireTaskParam;
import com.bxm.newidea.component.vo.Message;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Component
public class InviteRelationshipTask extends AbstractRuntimeJob {

    @Autowired
    private InviteRelationshipMapper inviteRelationshipMapper;

    @Autowired
    private UserAccountIntegService userAccountIntegService;

    public InviteRelationshipTask() {
        super("inviteRelationshipTask", TaskGroup.ONCE);
        super.setCount(0);
    }

    @Override
    protected Message run() {
        logger.debug("定时解除邀请关系开始执行:", JSON.toJSONString(this));
        Map<String, Object> paramMap = this.getParam();

        if (null != paramMap) {
            InviteExpireTaskParam param = (InviteExpireTaskParam) this.getParam().get("parameter");
            logger.info("定时解除邀请关系任务参数：{}", JSONObject.toJSONString(param));
            if (null == param || null == param.getInvitedUserId()) {
                return Message.build(false).setMessage("被邀请人ID为空");
            }

            AccountCashParam accountCashParam = new AccountCashParam();
            accountCashParam.setCashType("TEMP_CASH");
            accountCashParam.setAddTotal(false);

            if (null != param.getInviteUserId()) {
                List<Map<String, Object>> idAwardMapList = inviteRelationshipMapper.getIdAndInvitedAward(param.getInviteUserId(), param.getInvitedUserId());
                if (CollectionUtils.isNotEmpty(idAwardMapList)) {
                    Long id = Long.valueOf(idAwardMapList.get(0).get("id").toString());
                    BigDecimal award = new BigDecimal(idAwardMapList.get(0).get("award").toString());
                    if (null != award && award.compareTo(new BigDecimal(0)) > 0) {
                        accountCashParam.setRelationId(id);
                        accountCashParam.setCash(award.multiply(new BigDecimal(-1)));
                        accountCashParam.setCashFlowType("INVALID_BOUNTY");

                        accountCashParam.setUserId(param.getInviteUserId());
                        userAccountIntegService.addCash(accountCashParam);

                        accountCashParam.setCashFlowType("INVALID_PACKET");
                        accountCashParam.setUserId(param.getInvitedUserId());
                        userAccountIntegService.addCash(accountCashParam);
                    }
                }
                inviteRelationshipMapper.removeInviteRecord(param.getInviteUserId(), param.getInvitedUserId());
                inviteRelationshipMapper.removeUserInvite(param.getInvitedUserId());
            } else {
                BigDecimal tempCash = inviteRelationshipMapper.getAccountTempCash(param.getInvitedUserId());
                if (null != tempCash && tempCash.compareTo(new BigDecimal(0)) > 0) {
                    accountCashParam.setUserId(param.getInvitedUserId());
                    accountCashParam.setRelationId(null);
                    accountCashParam.setCash(tempCash.multiply(new BigDecimal(-1)));
                    accountCashParam.setCashFlowType("INVALID_PACKET");
                    userAccountIntegService.addCash(accountCashParam);
                }
            }

            //若24小时未登录app,则视为赏金过期。
            inviteRelationshipMapper.updateReceiveRedPacket(param.getInvitedUserId());

            return Message.build(true);
        }

        return Message.build(false).setMessage("解除邀请关系任务调度失败，缺少参数注入");
    }


}
