package com.bxm.localnews.quartz.runtime;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.quartz.domain.NewsMonitorMapper;
import com.bxm.localnews.quartz.facade.DingtalkPushService;
import com.bxm.localnews.quartz.integration.NewsIntegrationService;
import com.bxm.localnews.quartz.param.MonitorTaskBuildParam;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;

/**
 * 新闻模块
 * 根据新闻配置的监控策略定时运行，判断到底时间点后新闻是否达到了指定的数量
 */
@Component
public class NewsMonitorTask extends AbstractRuntimeJob {

    @Autowired
    private NewsMonitorMapper newsMonitorMapper;

    @Autowired
    private DingtalkPushService dingtalkPushService;

    @Autowired
    private NewsIntegrationService newsIntegrationService;

    public NewsMonitorTask() {
        super("NewsMonitorTask", "once");
        super.setCount(0);
    }

    @Override
    public Message run() {
        Map<String, Object> paramMap = this.getParam();

        if (null != paramMap) {
            MonitorTaskBuildParam param = (MonitorTaskBuildParam) this.getParam().get("parameter");
            logger.warn("新闻监控执行参数：{}", JSONObject.toJSONString(param));
            if (null == param || null == param.getIndexId() || null == param.getMonitorId() || param.getNum() == null) {
                return Message.build(false).setMessage("新闻监控ID为空，监控指标为空");
            }

            //根据触发时间来调用新闻数据汇总
            Date startTime = new Date();
            startTime = DateUtils.clearTimePart(startTime);

            Date endTime = DateUtils.addField(startTime, Calendar.HOUR_OF_DAY, NumberUtils.parseToInt(param.getFireTime()));

            param.setStartTime(DateUtils.formatDateTime(startTime));
            param.setEndTime(DateUtils.formatDateTime(endTime));
            if (0 == param.getKindId()) {
                param.setKindId(null);
            }
            if (StringUtils.isNotBlank(param.getAreaCodes())) {
                String[] areaArray = StringUtils.split(param.getAreaCodes(), ",");
                for (String areaCode : areaArray) {
                    param.setAreaCode(areaCode);
                    logger.warn("新闻监控执行参数[增加时间区间]：{}", JSONObject.toJSONString(param));
                    sendMsg(newsIntegrationService.countNews(param), areaCode);
                }
            } else {
                sendMsg(newsIntegrationService.countNews(param), null);
            }
        }
        return Message.build(false).setMessage("新闻监控任务调度失败，缺少参数注入");
    }

    private void sendMsg(int total, String areaCode) {
        MonitorTaskBuildParam param = (MonitorTaskBuildParam) this.getParam().get("parameter");

        if (total < param.getNum()) {
            String content = "监控指标[" + param.getName() + "]异常，要求新闻数量:[" + param.getNum() + "],实际数量:[" + total + "]";
            if (areaCode != null) {
                content += "，监控区域：[" + newsMonitorMapper.getAreaName(areaCode) + "]";
            }
            dingtalkPushService.push(content);

            newsIntegrationService.updateMonitorStatus(param.getMonitorId(), 1, content);
        } else {
            newsIntegrationService.updateMonitorStatus(param.getMonitorId(), 0, null);
        }
    }
}
