package com.bxm.localnews.quartz.runtime;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.integration.NewsIntegrationService;
import com.bxm.localnews.quartz.param.OptimizationNoticeParam;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 推荐库 优化通知 定时任务
 */
@Component
public class OptimizationNoticeTask extends AbstractRuntimeJob  {

	@Autowired
	private  NewsIntegrationService newsIntegrationService;

	public OptimizationNoticeTask() {
		super("OptimizationNoticeTask", TaskGroup.ONCE);
		super.setCount(0);
	}
	@Override
	protected Message run() {
		Map<String, Object> param = getParam();
		OptimizationNoticeParam parameter = (OptimizationNoticeParam)param.get("parameter");
		logger.info(" 优化通知 定时任务开始执行,参数为{}", JSONObject.toJSONString(parameter));
		Boolean flag = newsIntegrationService.sendOptimizationNotice(parameter);
		if (flag){
			return Message.build(true);
		}
		return Message.build(false).setMessage("优化通知发送任务失败,请查看日志");
	}
}
