/*
 * Copyright 2019 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.quartz.runtime;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.quartz.constant.RedisConfig;
import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.integration.NewsIntegrationService;
import com.bxm.localnews.quartz.param.PublishNewsBuildParam;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 定时发布新闻
 */
@Component
public class PublishNewsTask extends AbstractRuntimeJob {

    private Logger             logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    private NewsIntegrationService newsIntegrationService;

    public PublishNewsTask(){
        super("newsPublish", TaskGroup.ONCE);
        super.setCount(0);
    }

    @Override
    protected Message run () {
        logger.debug("定时新闻发布开始执行:", JSON.toJSONString(this));
        Map<String,Object> paramMap = this.getParam();
        logger.debug(JSON.toJSONString(paramMap));
        if (null != paramMap) {
            PublishNewsBuildParam param = (PublishNewsBuildParam) this.getParam().get("parameter");
            String areaCodes = param.getAreaCodes();
            Long newsId = param.getNewsId();
            newsIntegrationService.publishNews(newsId);
            this.clearRedisCacheOfTopNewsList(areaCodes);
            logger.info("id为{}的新闻发布成功", newsId);
            return Message.build(true);
        }
        return Message.build(true);

    }

    /**
     * 清除首页置顶新闻列表缓存
     */
    private void clearRedisCacheOfTopNewsList(String areaCodeStr) {
        logger.info("清除首页置顶新闻列表缓存开始执行:");
        if (StringUtils.isNotEmpty(areaCodeStr)) {
            String[] areaCodes = areaCodeStr.split(",");
            for (String areaCode : areaCodes) {
                KeyGenerator keyGenerator = RedisConfig.TOP_NEW_OF_AREA_LIST.copy().appendKey(areaCode);
                redisStringAdapter.remove(keyGenerator);
            }
        } else {
            // 清除全国性置顶新闻缓存
            redisStringAdapter.remove(RedisConfig.TOP_NEW_OF_WHOLE_COUNTRY_LIST);
        }

    }

}
