/*
 * Copyright 2019 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.quartz.runtime;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.quartz.constant.RedisConfig;
import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.integration.NewsIntegrationService;
import com.bxm.localnews.quartz.param.UserTopPostBuildParam;
import com.bxm.localnews.quartz.vo.ForumTopPost;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.vo.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 定时发布新闻
 */
@Component
public class UserTopPostTask extends AbstractRuntimeJob {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    private RedisListAdapter redisListAdapter;

    @Autowired
    private NewsIntegrationService newsIntegrationService;

    public UserTopPostTask() {
        super("userTopPostClean", TaskGroup.ONCE);
        super.setCount(0);
    }

    @Override
    protected Message run() {
        logger.debug("定时清理用户帖子置顶开始执行:", JSON.toJSONString(this));
        Map<String, Object> paramMap = this.getParam();
        logger.debug(JSON.toJSONString(paramMap));
        if (null != paramMap) {
            UserTopPostBuildParam param = (UserTopPostBuildParam) this.getParam().get("parameter");
            Long postId = param.getPostId();
            Long userId = param.getUserId();
            this.clearRedisCacheOfUserTopNewsList(userId);
            logger.info("id为{}的帖子取消用户置顶成功", postId);
            return Message.build(true);
        }
        return Message.build(true);

    }

    /**
     * 清除首页用户置顶新闻列表缓存
     */
    private void clearRedisCacheOfUserTopNewsList(Long userId) {
        KeyGenerator postUserTop = RedisConfig.FORUM_RECOMMENDED.copy().appendKey(userId).appendKey("top");

        Long size = redisListAdapter.size(postUserTop);
        if (size == 0){
            return;
        }
        //得到该用户在一个小时内发的帖子
        List<ForumTopPost> forumTopPostList = redisListAdapter.leftIndex(postUserTop,size-1, ForumTopPost.class);
        logger.debug("[clearRedisCacheOfUserTopNewsList] 得到用户在一个小时以内发的帖子:{}", JSONObject.toJSONString(forumTopPostList));

        long currentTime = System.currentTimeMillis();

        //如果帖子中，有时间相比于现在超过55分钟了，就要把它去除，不再置顶
        forumTopPostList.removeIf(e->currentTime-e.getAddTime().getTime()>60*55*1000);
        redisListAdapter.remove(postUserTop);
        logger.debug("[clearRedisCacheOfUserTopNewsList] 取消用户在一个小时以前发的帖子置顶:{}", JSONObject.toJSONString(forumTopPostList));

        //把不符合去除条件的重新加回去
        redisListAdapter.rightPush(postUserTop,forumTopPostList.toArray(new ForumTopPost[0]));
    }

}
