package com.bxm.localnews.quartz.temp;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.quartz.config.DingtalkProperties;
import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.domain.UserStatisticsMapper;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.inner.IntervalMap;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 业务模块
 */
@Component
public class RegStatisticsTask extends AbstractCustomJob {

    @Resource
    private DingtalkProperties dingtalkProperties;

    @Resource
    private HttpClientService httpClientService;

    @Resource
    private UserStatisticsMapper userStatisticsMapper;

    public RegStatisticsTask() {
        super("regStaticsTask", TaskGroup.CALCULATE, "0 0 9 * * ?", "每日早上9点统计广德和富阳的注册人数和VIP人数");
    }

    @Override
    public Message service() {
        IntervalMap intervalMap = DateUtils.getInterval(DateUtils.Interval.YESTERDAY);
        List<Map<String, Integer>> regUserList = userStatisticsMapper.regUser(intervalMap.getStartTime(), intervalMap.getEndTime());
        List<Map<String, Integer>> vipUserList = userStatisticsMapper.vipUser(intervalMap.getStartTime(), intervalMap.getEndTime());

        StringBuilder content = new StringBuilder();
        content.append("昨日App内新注册用户：[\n");
        int sum = 0;

        for (Map<String, Integer> areaGroup : regUserList) {
            String total = areaGroup.get("total") + "";
            sum += NumberUtils.parseToInt(total);
            content.append(areaGroup.get("name")).append("[").append(total).append("]人\n");
        }
        content.append("]。共：[").append(sum).append("]\n");

        content.append("VIP激活情况：[\n");

        for (Map<String, Integer> vipGroup : vipUserList) {
            content.append(vipGroup.get("name")).append("-").append(vipGroup.get("total")).append("\n");
        }
        content.append("]。");

        JSONObject text = new JSONObject();
        text.put("content", content);

        JSONObject msg = new JSONObject();
        msg.put("msgtype", "text");
        msg.put("text", text);

        String response = httpClientService.doPostJson(dingtalkProperties.getRegStatisticsWebhook(), msg.toJSONString());
        logger.debug("dingding response:{}", response);
        return Message.build(true);
    }
}
