package com.bxm.localnews.quartz.timer;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.integration.NewsIntegrationService;
import com.bxm.localnews.quartz.vo.ForumPostClickCountVo;
import com.bxm.newidea.component.vo.Message;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@Component
public class CalcPostClickCountTask extends AbstractTask {

    @Resource
    private NewsIntegrationService newsIntegrationService;

    public CalcPostClickCountTask() {
        super("定时增加帖子阅读数任务", TaskGroup.CALCULATE,
                "30 1/6 * * * ? ", "每6分钟消费一次");
    }

    @Override
    public Message service() {
        logger.info(".....................................帖子阅读数相关计算 begin...................................");
        //调用新闻服务获取一天内阅读数小于6000的帖子
        List<ForumPostClickCountVo> forumPostClickCountVoList = newsIntegrationService.getRecentPosts(6000);

        if (CollectionUtils.isNotEmpty(forumPostClickCountVoList)) {
            logger.debug("获取到需要计算的帖子列表：" + JSON.toJSONString(forumPostClickCountVoList));
            List<Long> newForumPosts = new ArrayList<>();
            List<Long> oldPassedForumPosts = new ArrayList<>();
            List<Long> oldOtherForumPosts = new ArrayList<>();

            //根据1500的阅读数阈值及帖子状态分组
            for (ForumPostClickCountVo forumPostClickCountVo : forumPostClickCountVoList) {
                if (null == forumPostClickCountVo.getClickCount() || forumPostClickCountVo.getClickCount() < 1500) {
                    newForumPosts.add(forumPostClickCountVo.getId());
                } else if (forumPostClickCountVo.getStatus() != null) {
                    if (1 == forumPostClickCountVo.getStatus()) {
                        oldPassedForumPosts.add(forumPostClickCountVo.getId());
                    } else {
                        oldOtherForumPosts.add(forumPostClickCountVo.getId());
                    }
                }
            }

            //小于1500的在40-60范围内增加
            if (CollectionUtils.isNotEmpty(newForumPosts)) {
                newsIntegrationService.batchAddClick(newForumPosts, 40 + new Random().nextInt(20));
            }

            //大于1500的审核通过帖子在2-20范围内增加
            if (CollectionUtils.isNotEmpty(oldPassedForumPosts)) {
                newsIntegrationService.batchAddClick(oldPassedForumPosts, 2 + new Random().nextInt(18));
            }

            //大于1500的其他状态帖子在2-5范围内增加
            if (CollectionUtils.isNotEmpty(oldOtherForumPosts)) {
                newsIntegrationService.batchAddClick(oldOtherForumPosts, 2 + new Random().nextInt(3));
            }
        }

        logger.info(".....................................帖子阅读数相关计算 end...................................");
        return Message.build(true);
    }

}
