package com.bxm.localnews.quartz.timer;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.quartz.config.DingtalkProperties;
import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.facade.NewsFeignService;
import com.bxm.localnews.quartz.integration.NewsIntegrationService;
import com.bxm.localnews.quartz.service.MoneyChangeService;
import com.bxm.localnews.quartz.vo.CalculateDto;
import com.bxm.localnews.quartz.vo.CalculatePost;
import com.bxm.localnews.quartz.vo.MoneyChange;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Component
public class CalculatePostTask extends AbstractTask {

    @Resource
    private DingtalkProperties dingtalkProperties;

    @Resource
    private HttpClientService httpClientService;

    @Autowired
    private NewsIntegrationService newsIntegrationService;

    public CalculatePostTask() {
        super("客户端发帖消息通知", TaskGroup.CALCULATE,
                "0 0/5 * * * ? ", "每5分钟消费一次");
    }

    @Override
    public Message service() {
        CalculateDto calculatePost = newsIntegrationService.getCalculatePost();
        if (CollectionUtils.isNotEmpty(calculatePost.getCalculates())){
            StringBuilder content = new StringBuilder();
            content.append("------").append(DateFormatUtils.format(new Date(),"MM月dd日HH时mm分")).append("------\n");
            calculatePost.getCalculates().stream().forEach(e->{
                content.append("地区：[").append(e.getAreaName()).append("]\n");
                content.append("最近5分钟新增待审核帖子：[").append(e.getPendingReviewCount()).append("]\n");
                content.append("最近5分钟手机端发帖数量：[").append(e.getNewPostCount()).append("]\n");
                content.append("最近5分钟手机端发帖人数：[").append(e.getUserCount()).append("]\n");
            });
            JSONObject text = new JSONObject();
            text.put("content", content);
            JSONObject msg = new JSONObject();
            msg.put("msgtype", "text");
            msg.put("text", text);
            String response = httpClientService.doPostJson(dingtalkProperties.getCalculatePostWebhook(), msg.toJSONString());
            logger.debug("dingding response:{}", response);
        }
        return Message.build();
    }


}
