package com.bxm.localnews.quartz.timer;

import java.util.Calendar;
import java.util.Date;

import javax.annotation.Resource;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.quartz.config.DingtalkProperties;
import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.service.MoneyChangeService;
import com.bxm.localnews.quartz.vo.MoneyChange;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/4/18 16:55
 * @desc
 */
@Component
public class CompanyAccountTask extends AbstractTask {

    @Resource
    private DingtalkProperties dingtalkProperties;

    @Resource
    private HttpClientService httpClientService;

    @Autowired
    private MoneyChangeService moneyChangeService;

    public CompanyAccountTask() {
        super("公司微信账户每小时相关信息统计", TaskGroup.REFRESH,
                "0 1 0/1 * * ? *", "每小时消费一次");
    }

    @Override
    public Message service() {
        Date now = new Date();
        Date beforeNow = DateUtils.addField(now, Calendar.HOUR, -1);
        String startTime = DateUtils.formatDateHour(beforeNow);
        String endTime = DateUtils.formatDateHour(now);

        MoneyChange moneyChange = moneyChangeService.changeMoneyStatisticsByHour(startTime, endTime);
        StringBuilder content = new StringBuilder();
        content.append("------").append(beforeNow.getMonth() + 1).append("月").append(beforeNow.getDate())
                .append("日").append(beforeNow.getHours()).append("时").append("------\n");

        content.append("转盘抽奖人数：[").append(moneyChange.getDrawNumber()).append("]\n");
        content.append("注册人数：[").append(moneyChange.getCountRegUser()).append("]\n");
        content.append("新增赏金总额：[").append(moneyChange.getTotalBounty().setScale(2)).append("]\n");
        content.append("发起提现人数：[").append(moneyChange.getWithdrawNumber()).append("]\n");
        content.append("提现总金额：[").append(moneyChange.getWithdarawAmount().setScale(2)).append("]\n");
        content.append("成功提现金额：[").append(moneyChange.getSuccessWithdrawAmount().setScale(2)).append("]\n");
        content.append("公司账户余额：[").append(moneyChange.getCompanyAmount()).append("]");

        JSONObject text = new JSONObject();
        text.put("content", content);

        JSONObject msg = new JSONObject();
        msg.put("msgtype", "text");
        msg.put("text", text);

        String response = httpClientService.doPostJson(dingtalkProperties.getRedPacketStatistics(), msg.toJSONString());
        logger.debug("dingding response:{}", response);
        return Message.build();
    }
}
