package com.bxm.localnews.quartz.timer;

import java.math.BigDecimal;

import javax.annotation.Resource;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.quartz.config.DingtalkProperties;
import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.service.MoneyChangeService;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/4/29 18:09
 * @desc
 */
@Component
public class ControlCompanyAccountTask extends AbstractTask {

    @Resource
    private DingtalkProperties dingtalkProperties;

    @Resource
    private HttpClientService httpClientService;

    @Autowired
    private MoneyChangeService moneyChangeService;

    public ControlCompanyAccountTask() {
        super("公司微信账户少于5000开始报警", TaskGroup.REFRESH,
                "0 0/5 * * * ? *", "每5分钟消费一次");
    }

    @Override
    public Message service() {
        BigDecimal companyAccount = moneyChangeService.getCompanyAccount();
        BigDecimal limitAmount = new BigDecimal(5000);
        BigDecimal alarmAmount = new BigDecimal(2000);

        //账户余额少于2000时
        if (companyAccount.compareTo(alarmAmount) < 1) {
            alarmMessage();
            return Message.build();
        }

        //账户余额小于5000时
        if (companyAccount.compareTo(limitAmount) < 1) {
            limitMessage();
        }


        return Message.build();
    }

    /**
     * 提醒账户余额少于5000
     */
    private void limitMessage() {
        StringBuilder content = new StringBuilder();
        content.append("@+86-15057101245 @+86-18767120507 公司账户余额少于5000");
        JSONObject text = new JSONObject();
        text.put("content", content);
        JSONObject at = new JSONObject();
        at.put("atMobiles", Lists.newArrayList("+86-15057101245", "+86-18767120507"));
        at.put("isAtAll", false);
        JSONObject msg = new JSONObject();
        msg.put("msgtype", "text");
        msg.put("text", text);
        msg.put("at", at);
        String response = httpClientService.doPostJson(dingtalkProperties.getRedPacketStatistics(), msg.toJSONString());
        logger.debug("dingding response:{}", response);
    }

    /**
     * 提醒账户余额少于2000
     */
    private void alarmMessage() {
        StringBuilder content = new StringBuilder();
        content.append("@+86-15057101245 @+86-18767120507 公司账户余额少于2000");
        JSONObject text = new JSONObject();
        text.put("content", content);
        JSONObject at = new JSONObject();
        at.put("atMobiles", Lists.newArrayList("+86-15057101245", "+86-18767120507"));
        at.put("isAtAll", false);
        JSONObject msg = new JSONObject();
        msg.put("msgtype", "text");
        msg.put("text", text);
        msg.put("at", at);
        String response = httpClientService.doPostJson(dingtalkProperties.getRedPacketStatistics(), msg.toJSONString());
        logger.debug("dingding response:{}", response);
    }
}
