package com.bxm.localnews.quartz.timer;

import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.service.NewsQuartzService;
import com.bxm.newidea.component.vo.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ForumCalcTask extends AbstractTask  {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private NewsQuartzService newsQuartzService;

    public ForumCalcTask() {
        super("社区相关计算", TaskGroup.CALCULATE, "0 0/10 * * * ? *", "每十分钟消费一次");
    }

    @Override
    protected Message service() {
        logger.info(".....................................社区相关计算 begin...................................");
        newsQuartzService.calcParticipantsNum();
        logger.info(".....................................社区相关计算 end.....................................");
        return  Message.build(true);
    }
}
