package com.bxm.localnews.quartz.timer;

import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.facade.PushMsgIntegService;
import com.bxm.newidea.component.vo.Message;

import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author zhaoyadong 2019/4/29 10:22
 * @desc
 */
@Component
public class InteractionPushMessageTask extends AbstractTask {

    @Resource
    private PushMsgIntegService pushMsgIntegService;

    public InteractionPushMessageTask() {
        super("8点到22点给用户推送未读的互动消息", TaskGroup.REFRESH, "0 0/30 8-22 * * ? *", "每三十分钟消费一次");
    }

    @Override
    protected Message service() {
        pushMsgIntegService.pushInteractionMessage();
        return Message.build();
    }
}
