package com.bxm.localnews.quartz.timer;

import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.service.NewsKindQuartzService;
import com.bxm.newidea.component.vo.Message;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2018/11/12 21:42
 * @desc
 */
@Component
public class NewsKindConsumer extends AbstractTask {

    @Autowired
    private NewsKindQuartzService newsKindQuartzService;

    public NewsKindConsumer() {
        super("用户新闻频道同步", TaskGroup.CALCULATE, "0 0/5 * * * ?", "每五分钟消费一次");
    }

    @Override
    protected Message service() {
        newsKindQuartzService.syncMykindToData();
        return Message.build(true);
    }
}
