package com.bxm.localnews.quartz.timer;

import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.service.NewsReplyService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsReplySyncTask extends AbstractTask {

    @Autowired
    private NewsReplyService newsReplyService;

    public NewsReplySyncTask() {
        super("扫描新闻评论表", TaskGroup.PUSH, "0 0/5 * * * ?", "每五分钟消费一次");
    }

    @Override
    protected Message service() {
        logger.info("扫描新闻评论表");
        newsReplyService.updateNewsReplyStatus();
        return Message.build(true);
    }
}
