package com.bxm.localnews.quartz.timer;

import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.facade.NewsFeignService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PostLikeRefreshTask extends AbstractTask{

    public PostLikeRefreshTask() {
        super("定时修改帖子点赞数据", TaskGroup.REFRESH, "0 3/5 * * * ? ", "每5分钟消费一次");
    }

    @Autowired
    private NewsFeignService newsFeignService;
    @Override
    protected Message service() {
        logger.info("定时修改帖子点赞数据..............");
        newsFeignService.refreshLikeInfo();
        return  Message.build(true);
    }
}
