package com.bxm.localnews.quartz.timer;

import com.bxm.localnews.quartz.constant.TaskGroup;
import com.bxm.localnews.quartz.service.RedPacketQuartzService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 红包审核后推送定时任务
 * @author donghy
 */
@Component
public class RedPacketPushTask extends AbstractTask {

    /**
     * 红包定时任务
     */
    @Autowired
    private RedPacketQuartzService redPacketQuartzService;


    public RedPacketPushTask() {
        super("红包信息推送", TaskGroup.PUSH,
                "0 0 11 * * ?", "红包审核通过后第二天的11点推送红包领取消息");
    }


    @Override
    protected Message service() {

        redPacketQuartzService.pushMessage();
        return Message.build(true);
    }
}
