package com.bxm.newidea.controller;

import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.service.ForumService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 *      论坛帖子相关推荐
 * </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/3
 */
@RestController
@RequestMapping("api/forum")
public class ForumController {

    private ForumService forumService;

    @Autowired
    public ForumController(ForumService forumService){
        this.forumService = forumService;
    }

    @ApiOperation(value = "论坛帖子推荐接口", httpMethod = "GET",
            notes = "论坛详情时，需要指定返回的本地新闻newsNum和本地帖子postNum数量，返回的结果前newsNum为本地新闻，如果本地新闻无，则前newsNum条为0")
    @GetMapping(value = "/recommendList")
    public ResponseEntity<List<Long>> recommendList(@RequestBody ForumParam forumParam){
        return ResponseEntity.ok(forumService.recommend(forumParam));
    }

    @ApiOperation(value = "取消用户帖子置顶", notes = "给新闻模块删除帖子、运营管理后台删除或拒审时调用,删除redis中用户帖子的缓存")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "postId", value = "帖子ID", required = true)
    })
    @DeleteMapping("/userTop/cache")
    public ResponseEntity getMixRecommendList(@RequestParam("userId")Long userId,
                                              @RequestParam("postId")Long postId){
        forumService.cleanUserTop(userId,postId);
        return ResponseEntity.ok().build();
    }

}
