package com.bxm.newidea.controller;

import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.param.MixQueryParam;
import com.bxm.newidea.recommend.engine.MixRecommendEngine;
import com.bxm.newidea.service.MixRecommendService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("api/index")
public class MixRecommendController {

    @Autowired
    private MixRecommendEngine recommendEngine;

    @Autowired
    private MixRecommendService mixRecommendService;

    @ApiOperation(value = "混合推荐接口", notes = "首页推荐（包括帖子和新闻），详细推荐逻辑见confuence产品研发记录2.1.0")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "actionType", value = "动作参数(2上划,1下拉)"),
            @ApiImplicitParam(name = "pageSize", value = "分页大小 默认10", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码")
    })
    @RequestMapping("/mixRecommendList")
    public List<MixRecomendResult> getMixRecommendList(@RequestBody MixQueryParam mixQueryParam) {
        return recommendEngine.recommendMixResult(mixQueryParam);
    }

    @ApiOperation(value = "混合推荐接口清理缓存接口", notes = "在用户切换地区时,需要清除首页以及社区首页的推荐记录以及缓存信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    })
    @DeleteMapping("/mixRecommendList/cache")
    public ResponseEntity getMixRecommendList(@RequestParam("userId") Long userId) {
        mixRecommendService.cleanMixCache(userId);
        return ResponseEntity.ok().build();
    }
}
