package com.bxm.newidea.controller;


import com.bxm.newidea.service.RecommendService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("api/news")
public class NewsController {

    private RecommendService recommendService;

    @Autowired
    NewsController(RecommendService recommendService) {
        this.recommendService = recommendService;
    }

    @ApiOperation(value = "新闻推荐接口", httpMethod = "GET", notes = "给业务系统调用 仅返回新闻id 文章内容另行组装")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "kindId", value = "频道id 本地新闻 频道：-1"),
            @ApiImplicitParam(name = "pageSize", value = "分页大小", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码")
    })
    @GetMapping(value = "recommendList")
    public ResponseEntity<List<Long>> recommendList(@RequestParam("userId") Long userId,
                                                    @RequestParam(value = "kindId", required = false) Integer kindId,
                                                    @RequestParam("pageSize") Integer pageSize,
                                                    @RequestParam(value = "areaCode", required = false) String areaCode,
                                                    @RequestParam(value = "curPage") Integer curPage) {
        List<Long> ids = recommendService.recommend(userId, kindId, pageSize, areaCode, curPage);
        return new ResponseEntity<>(ids, HttpStatus.OK);
    }

    @ApiOperation(value = "新闻详情页推荐接口（相关推荐）", httpMethod = "GET", notes = "给业务系统调用 仅返回新闻id 文章内容另行组装")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻ID", required = true),
            @ApiImplicitParam(name = "userId", value = "用户ID")
    })
    @GetMapping(value = "recommendByNewsDetail")
    public ResponseEntity<List<Long>> recommendByNewsDetail(@RequestParam(value = "newsId") Long newsId,
                                                            @RequestParam(value = "userId", required = false) Long userId,
                                                            @RequestParam(value = "size", required = false) Integer size,
                                                            @RequestParam(value = "platform", required = false,defaultValue = "1") Integer platform
                                                            ) {
        List<Long> ids = recommendService.recommendByNewsDetail(userId, newsId, size ,platform);
        return new ResponseEntity<>(ids, HttpStatus.OK);
    }

}
