/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.aspect;

import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class HttpAspect {
    private static final Logger logger = LoggerFactory.getLogger(HttpAspect.class);
    private static ThreadLocal<Long> startTime = new ThreadLocal();

    @Pointcut(value="execution(public * com.bxm.newidea.controller.*Controller.*(..))")
    public void log() {
    }

    @Before(value="log()")
    public void doBefore(JoinPoint joinPoint) {
        startTime.set(System.currentTimeMillis());
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            StringBuffer url = request.getRequestURL();
            String method = request.getMethod();
            String remoteAddr = request.getRemoteAddr();
            String classMethod = joinPoint.getSignature().getDeclaringTypeName() + "." + joinPoint.getSignature().getName();
            Object[] args = joinPoint.getArgs();
            logger.debug("url={},method={},ip={},class_method={},args={}", new Object[]{url, method, remoteAddr, classMethod, args});
        }
    }

    @After(value="log()")
    public void doAfter() {
    }

    @AfterReturning(returning="obj", pointcut="log()")
    public void doAfterReturning(Object obj) {
        logger.debug("response={}", obj);
        logger.info("\u54cd\u5e94\u65f6\u957f={}ms", (Object)(System.currentTimeMillis() - startTime.get()));
        startTime.remove();
    }
}

