/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.controller;

import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.service.ForumService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/forum"})
public class ForumController {
    private ForumService forumService;

    @Autowired
    public ForumController(ForumService forumService) {
        this.forumService = forumService;
    }

    @ApiOperation(value="\u8bba\u575b\u5e16\u5b50\u63a8\u8350\u63a5\u53e3", httpMethod="GET", notes="\u8bba\u575b\u8be6\u60c5\u65f6\uff0c\u9700\u8981\u6307\u5b9a\u8fd4\u56de\u7684\u672c\u5730\u65b0\u95fbnewsNum\u548c\u672c\u5730\u5e16\u5b50postNum\u6570\u91cf\uff0c\u8fd4\u56de\u7684\u7ed3\u679c\u524dnewsNum\u4e3a\u672c\u5730\u65b0\u95fb\uff0c\u5982\u679c\u672c\u5730\u65b0\u95fb\u65e0\uff0c\u5219\u524dnewsNum\u6761\u4e3a0")
    @PostMapping(value={"/recommendList"})
    public ResponseEntity<List<Long>> recommendList(@RequestBody ForumParam forumParam) {
        return ResponseEntity.ok((Object)this.forumService.recommend(forumParam));
    }

    @ApiOperation(value="\u53d6\u6d88\u7528\u6237\u5e16\u5b50\u7f6e\u9876", notes="\u7ed9\u65b0\u95fb\u6a21\u5757\u5220\u9664\u5e16\u5b50\u3001\u8fd0\u8425\u7ba1\u7406\u540e\u53f0\u5220\u9664\u6216\u62d2\u5ba1\u65f6\u8c03\u7528,\u5220\u9664redis\u4e2d\u7528\u6237\u5e16\u5b50\u7684\u7f13\u5b58")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="postId", value="\u5e16\u5b50ID", required=true)})
    @DeleteMapping(value={"/userTop/cache"})
    public ResponseEntity getMixRecommendList(@RequestParam(value="userId") Long userId, @RequestParam(value="postId") Long postId) {
        this.forumService.cleanUserTop(userId, postId);
        return ResponseEntity.ok().build();
    }
}

