/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.controller;

import com.bxm.newidea.service.RecommendService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/news"})
public class NewsController {
    private RecommendService recommendService;

    @Autowired
    NewsController(RecommendService recommendService) {
        this.recommendService = recommendService;
    }

    @ApiOperation(value="\u65b0\u95fb\u63a8\u8350\u63a5\u53e3", httpMethod="GET", notes="\u7ed9\u4e1a\u52a1\u7cfb\u7edf\u8c03\u7528 \u4ec5\u8fd4\u56de\u65b0\u95fbid \u6587\u7ae0\u5185\u5bb9\u53e6\u884c\u7ec4\u88c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="kindId", value="\u9891\u9053id \u672c\u5730\u65b0\u95fb \u9891\u9053\uff1a-1"), @ApiImplicitParam(name="pageSize", value="\u5206\u9875\u5927\u5c0f", required=true), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801")})
    @GetMapping(value={"recommendList"})
    public ResponseEntity<List<Long>> recommendList(@RequestParam(value="userId") Long userId, @RequestParam(value="kindId", required=false) Integer kindId, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="areaCode", required=false) String areaCode, @RequestParam(value="curPage") Integer curPage) {
        List ids = this.recommendService.recommend(userId, kindId, pageSize, areaCode, curPage);
        return new ResponseEntity((Object)ids, HttpStatus.OK);
    }

    @ApiOperation(value="\u65b0\u95fb\u8be6\u60c5\u9875\u63a8\u8350\u63a5\u53e3\uff08\u76f8\u5173\u63a8\u8350\uff09", httpMethod="GET", notes="\u7ed9\u4e1a\u52a1\u7cfb\u7edf\u8c03\u7528 \u4ec5\u8fd4\u56de\u65b0\u95fbid \u6587\u7ae0\u5185\u5bb9\u53e6\u884c\u7ec4\u88c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="newsId", value="\u65b0\u95fbID", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID")})
    @GetMapping(value={"recommendByNewsDetail"})
    public ResponseEntity<List<Long>> recommendByNewsDetail(@RequestParam(value="newsId") Long newsId, @RequestParam(value="userId", required=false) Long userId, @RequestParam(value="size", required=false) Integer size, @RequestParam(value="platform", required=false, defaultValue="1") Integer platform, @RequestParam(value="areaCode", required=false) String areaCode) {
        List ids = this.recommendService.recommendByNewsDetail(userId, newsId, size, platform, areaCode);
        return new ResponseEntity((Object)ids, HttpStatus.OK);
    }
}

