package com.bxm.newidea.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;



/**
 * redis 缓存的key值，格式为： {业务类型：模块：子模块:更下级模块}
 * 业务类型： biz:业务  config:配置
 */
public class RedisKeyConstant {
    /**
     * 推荐给个人用户的新闻缓存
     */
    public static KeyGenerator NEWS_RECOMMEND = DefaultKeyGenerator.build("news", "usercache");

    /**
     * 推荐给个人用户的新闻缓存(首页缓冲池)
     */
    public static KeyGenerator NEWS_COMMON_RECOMMEND = DefaultKeyGenerator.build("news", "recommendcache");

    /**
     * 推荐给个人用户的新闻缓存(协同过滤key)
     */
    public static KeyGenerator NEWS_COLLABORATIVE_RECOMMEND = DefaultKeyGenerator.build("news", "usercache","collaborative");

    /**
     * 已经推荐给用户的新闻列表(新)
     * 以set存储
     */
    public static  KeyGenerator NEWS_NEW_RECOMMENDED = DefaultKeyGenerator.build("news", "isRecommended");

    /**
     * 推荐给个人用户的新闻缓存(新)
     */
    public static KeyGenerator NEWS_NEW_RECOMMEND = DefaultKeyGenerator.build("news", "newusercache");

    /**
     * 推荐给个人用户的新闻缓存(首页缓冲池)(新)
     */
    public static KeyGenerator NEWS_NEW_COMMON_RECOMMEND = DefaultKeyGenerator.build("news", "newrecommendcache");

    /**
     * 推荐给个人用户的小视频缓存
     */
    public static KeyGenerator VIDEO_RECOMMEND = DefaultKeyGenerator.build("video", "usercache");

    /**
     * 已经推荐给用户的视频列表
     */
    public static KeyGenerator VIDEO_RECOMMENDED = DefaultKeyGenerator.build("video", "recommended");

    /**
     * 全局的新闻黑名单key
     */
    public static KeyGenerator NEWS_BLACK =DefaultKeyGenerator.build("news", "black");

    /**
     * 全局的小视频黑名单key
     */
    public static KeyGenerator VIDEO_BLACK =DefaultKeyGenerator.build("video", "black");

    /**
     * 全局的帖子黑名单key
     */
    public static KeyGenerator FORUM_BLACK =DefaultKeyGenerator.build("forum", "black");

    /**
     * 论坛帖子已经推荐列表
     */
    public static KeyGenerator FORUM_RECOMMENDED = DefaultKeyGenerator.build("forum","recommended");

    /**
     * 混合-用户最后一次阅读时间
     */
    @Deprecated
    public static  KeyGenerator MIX_LAST_READ_TIME = DefaultKeyGenerator.build("mix", "record","lastreadtime");

    /**
     * 混合-固定推荐池index
     */
    @Deprecated
    public static  KeyGenerator MIX_FIX_INDEX = DefaultKeyGenerator.build("mix", "index","fix");

    /**
     * 混合-最新推荐池数据，每个用户一个推荐池
     */
    @Deprecated
    public static  KeyGenerator MIX_RECENTLY_POOL = DefaultKeyGenerator.build("mix", "pool","recently");

    /**
     * 混合-个人历史推荐记录
     */
    @Deprecated
    public static  KeyGenerator MIX_RECOMMENDED = DefaultKeyGenerator.build("mix", "recommended","browsingKey");
}
