package com.bxm.newidea.vo;

import io.swagger.annotations.ApiModel;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 帖子信息表
 * </p>
 *
 * @author JandMin
 * @since 2019-04-03
 */
@ApiModel(description = "帖子信息")
public class ForumPost implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    /**
     * 所属板块ID
     */
    private Long forumId;
    /**
     * 帖子内容（最终显示文本，HTML）
     */
    private String content;
    /**
     * 帖子文本部分
     */
    private String textField;
    /**
     * 帖子图片（json字符串）
     */
    private String imgList;
    /**
     * 帖子标题
     */
    private String title;
    /**
     * 发帖时的用户位置（默认取所属区域名称）
     */
    private String location;
    /**
     * 发帖用户所属区域
     */
    private String areaCode;
    /**
     * 发帖用户ID
     */
    private Long userId;
    /**
     * 发帖用户头像
     */
    private String userImg;
    /**
     * 发帖用户名称
     */
    private String userName;
    /**
     * 是否精华帖(显示精华帖的章)
     */
    private Integer isBrilliant;
    /**
     * 是否推荐
     */
    private Integer isRecommend;
    /**
     * 是否红色章（只对精华帖有效）
     */
    private Integer isRed;
    /**
     * 是否发放了现金奖励
     */
    private Integer isCash;
    /**
     * 创建时间（真实的创建时间）
     */
    private Date createTime;
    /**
     * 创建人（仅针对运营录入）
     */
    private Long creator;
    /**
     * 展示标签：1热 2爆
     */
    private Integer displayTag;
    /**
     * 发布时间（用于运营定时发布）
     */
    private Date publishTime;
    /**
     * 发布时间（用于客户端显示）
     */
    private Date displayTime;
    /**
     * 帖子状态（1：正常显示，2：审核中，3：已下线，4：已删除）
     */
    private Integer status;
    /**
     * 阅读(点击)总数
     */
    private Long clickCount;
    /**
     * 有效阅读总数
     */
    private Long reviewCount;
    /**
     * 评论总数
     */
    private Long commentCount;
    /**
     * 分享总数
     */
    private Long shareCount;
    /**
     * 收藏总数
     */
    private Long collectCount;
    /**
     * 推荐总次数
     */
    private Long recommendCount;
    /**
     * 点赞总数
     */
    private Long likeCount;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getForumId() {
        return forumId;
    }

    public void setForumId(Long forumId) {
        this.forumId = forumId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getTextField() {
        return textField;
    }

    public void setTextField(String textField) {
        this.textField = textField;
    }

    public String getImgList() {
        return imgList;
    }

    public void setImgList(String imgList) {
        this.imgList = imgList;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserImg() {
        return userImg;
    }

    public void setUserImg(String userImg) {
        this.userImg = userImg;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Integer getIsBrilliant() {
        return isBrilliant;
    }

    public void setIsBrilliant(Integer isBrilliant) {
        this.isBrilliant = isBrilliant;
    }

    public Integer getIsRecommend() {
        return isRecommend;
    }

    public void setIsRecommend(Integer isRecommend) {
        this.isRecommend = isRecommend;
    }

    public Integer getIsRed() {
        return isRed;
    }

    public void setIsRed(Integer isRed) {
        this.isRed = isRed;
    }

    public Integer getIsCash() {
        return isCash;
    }

    public void setIsCash(Integer isCash) {
        this.isCash = isCash;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getCreator() {
        return creator;
    }

    public void setCreator(Long creator) {
        this.creator = creator;
    }

    public Integer getDisplayTag() {
        return displayTag;
    }

    public void setDisplayTag(Integer displayTag) {
        this.displayTag = displayTag;
    }

    public Date getPublishTime() {
        return publishTime;
    }

    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    public Date getDisplayTime() {
        return displayTime;
    }

    public void setDisplayTime(Date displayTime) {
        this.displayTime = displayTime;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getClickCount() {
        return clickCount;
    }

    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    public Long getReviewCount() {
        return reviewCount;
    }

    public void setReviewCount(Long reviewCount) {
        this.reviewCount = reviewCount;
    }

    public Long getCommentCount() {
        return commentCount;
    }

    public void setCommentCount(Long commentCount) {
        this.commentCount = commentCount;
    }

    public Long getShareCount() {
        return shareCount;
    }

    public void setShareCount(Long shareCount) {
        this.shareCount = shareCount;
    }

    public Long getCollectCount() {
        return collectCount;
    }

    public void setCollectCount(Long collectCount) {
        this.collectCount = collectCount;
    }

    public Long getRecommendCount() {
        return recommendCount;
    }

    public void setRecommendCount(Long recommendCount) {
        this.recommendCount = recommendCount;
    }

    public Long getLikeCount() {
        return likeCount;
    }

    public void setLikeCount(Long likeCount) {
        this.likeCount = likeCount;
    }

    @Override
    public String toString() {
        return "ForumPost{" +
        "id=" + id +
        ", forumId=" + forumId +
        ", content=" + content +
        ", textField=" + textField +
        ", imgList=" + imgList +
        ", title=" + title +
        ", location=" + location +
        ", areaCode=" + areaCode +
        ", userId=" + userId +
        ", userImg=" + userImg +
        ", userName=" + userName +
        ", isBrilliant=" + isBrilliant +
        ", isRecommend=" + isRecommend +
        ", isRed=" + isRed +
        ", isCash=" + isCash +
        ", createTime=" + createTime +
        ", creator=" + creator +
        ", displayTag=" + displayTag +
        ", publishTime=" + publishTime +
        ", displayTime=" + displayTime +
        ", status=" + status +
        ", clickCount=" + clickCount +
        ", reviewCount=" + reviewCount +
        ", commentCount=" + commentCount +
        ", shareCount=" + shareCount +
        ", collectCount=" + collectCount +
        ", recommendCount=" + recommendCount +
        ", likeCount=" + likeCount +
        "}";
    }
}
