package com.bxm.newidea.vo;

import lombok.Data;

import java.util.Date;

/**
 * 新闻阅读记录
 */
@Data
public class NewsRecord {

    /**
     * 主键
     */
    private Long id;

    /**
     * 新闻id
     */
    private Long newsId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 浏览时长
     */
    private Integer checkTime;

    /**
     * 广告位是否被展示出来  1：否  2：是
     */
    private Byte adViewType;

    /**
     * 是否读取到文章末尾  1：否  2：是
     */
    private String lastLocation;

    /**
     * 是否获取金币 1：否  2：是
     */
    private Byte getGold;

    /**
     * 获取金币时间
     */
    private Date getGoldTime;

    /**
     * 获取金币的时间间隔
     */
    private Integer intervalNum;

    /**
     * 0有效   1删除
     */
    private Byte isDel;

    private Date addTime;

    private Date updateTime;

    /**
     * 是否是有效阅读 1：否  2：是
     */
    private Byte activeView;


}
