package com.bxm.newidea.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class Video implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 第三方导入的ID
     */
    private Long tid;

    /**
     * 视频描述
     */
    private String description;

    /**
     * 视频标题
     */
    private String title;

    /**
     * 视频图片
     */
    private String videoImg;

    /**
     * 视频播放地址
     */
    private String videoUrl;

    /**
     * 作者ID
     */
    private Long authorId;

    /**
     * 作者头像
     */
    private String authorImg;

    /**
     * 作者名称
     */
    private String authorName;

    /**
     * 视频创建时间
     */
    private Date createTime;

    /**
     * 爬取时间
     */
    private Date issueTime;

    /**
     * 视频状态（0：无效，1：有效）
     */
    private Byte status;

    /**
     * 评论次数
     */
    private Long commentCount;

    /**
     * 分享次数
     */
    private Long shareCount;

    /**
     * 点赞次数
     */
    private Long likeCount;

    /**
     * 点击播放次数
     */
    private Long clickCount;

    private Double widthRatio;

    private static final long serialVersionUID = 1L;


}