package com.bxm.newidea.recommend;


import com.bxm.newidea.dto.VideoDto;

import java.util.List;
import java.util.Objects;

/**
 * 推荐抽象类
 */
public abstract class AbstractRecommender {

    private double weight;

    private int sort;

    public AbstractRecommender(double weight, int sort) {
        this.weight = weight;
        this.sort = sort;
    }

    public Double getWeight() {
        return weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public abstract List<Long> recommendNews(Long userId, Integer kindId, Integer num, String areaCode);

    public abstract List<VideoDto> recommendVideo(Long user, Integer num);


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AbstractRecommender that = (AbstractRecommender) o;
        return Double.compare(that.weight, weight) == 0 &&
                sort == that.sort;
    }

    @Override
    public int hashCode() {
        return Objects.hash(weight, sort);
    }
}
