package com.bxm.newidea.recommend.handler.news;


import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.domain.NewsPoolMapper;
import com.bxm.newidea.domain.NewsRecommendedMapper;
import com.bxm.newidea.integration.NewsSyncIntegrationService;
import com.bxm.newidea.recommend.AbstractNewsRecommender;
import com.bxm.newidea.vo.News;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 应急推荐策略 缓存过期或者各种策略都无结果时使用
 */
@Component
public class EmergencyNewsRecommender extends AbstractNewsRecommender {

    private NewsPoolMapper newsPoolMapper;

    @Autowired(required = false)
    public EmergencyNewsRecommender(NewsPoolMapper newsPoolMapper,
                                    RedisListAdapter redisListAdapter,
                                    NewsRecommendedMapper newsRecommendedMapper,
                                    NewsSyncIntegrationService newsSyncIntegrationService) {
        super(1,99);
        this.newsPoolMapper = newsPoolMapper;
        this.redisListAdapter = redisListAdapter;
        this.newsRecommendedMapper = newsRecommendedMapper;
        this.newsSyncIntegrationService = newsSyncIntegrationService;
    }

    @Override
    protected List<Long> syncRecommendNews(Long userId, Integer kindId, Integer num,String areaCode) {
        List<News> newsList;
        if (kindId==null) {
            newsList = newsPoolMapper.recommendNews(userId,36L,1,null,num);
        } else {
            newsList = newsPoolMapper.recommendNews(userId, Long.valueOf(kindId),null,null,num);
        }
        List<Long> ids = new ArrayList<>();
        newsList.forEach(news ->ids.add(news.getId()));
        return ids;
    }


    @Override
    protected void asyncRecommendNews(Long userId, Integer kindId, String areaCode) {

    }
}
