package com.bxm.newidea.recommend.handler.news;

import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.domain.HotnewsRecommendedMapper;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.domain.NewsRecommendedMapper;
import com.bxm.newidea.integration.NewsSyncIntegrationService;
import com.bxm.newidea.recommend.AbstractNewsRecommender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author leon 2019年1月24日 上午10:49:02
 * @ClassName HotNewsRecommender.java
 * @Description 功能描述： 热门新闻推荐策略
 * @CopyRight 杭州微财网络科技有限公司
 */
@Component
public class HotNewsRecommender extends AbstractNewsRecommender {

    private NewsMapper newsMapper;

    private HotnewsRecommendedMapper hotnewsRecommendedMapper;

    @Autowired(required = false)
    public HotNewsRecommender(NewsMapper newsMapper, RedisListAdapter redisListAdapter,
                              NewsRecommendedMapper newsRecommendedMapper,
                              HotnewsRecommendedMapper hotnewsRecommendedMapper,
                              NewsSyncIntegrationService newsSyncIntegrationService) {
        super(0.2, 0);
        this.newsMapper = newsMapper;
        this.redisListAdapter = redisListAdapter;
        this.newsRecommendedMapper = newsRecommendedMapper;
        this.hotnewsRecommendedMapper = hotnewsRecommendedMapper;
        this.newsSyncIntegrationService = newsSyncIntegrationService;
    }

    @Override
    protected List<Long> syncRecommendNews(Long userId, Integer kindId, Integer num, String areaCode) {
        if (kindId != null) {
            // 非推荐频道
            return new ArrayList<>();
        }
        List<Long> newsList = hotnewsRecommendedMapper.recommendHotNews(num, userId, areaCode);
        if (newsList != null && newsList.size() >= 2) {
            newsList = newsList.subList(0, 2);
        }
        return newsList;
    }

    @Override
    protected void asyncRecommendNews(Long userId, Integer kindId, String areaCode) {

    }
}
