package com.bxm.newidea.recommend.handler.news;

import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.domain.LocalnewsRecommendedMapper;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.domain.NewsRecommendedMapper;
import com.bxm.newidea.enums.NewsKindEnum;
import com.bxm.newidea.integration.NewsSyncIntegrationService;
import com.bxm.newidea.recommend.AbstractNewsRecommender;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 本地新闻策略
 */
@Component
public class LocalNewsRecommender extends AbstractNewsRecommender {

    private NewsMapper newsMapper;

    private LocalnewsRecommendedMapper localnewsRecommendedMapper;

    @Autowired(required = false)
    public LocalNewsRecommender(NewsMapper newsMapper, RedisListAdapter redisListAdapter,
                                NewsRecommendedMapper newsRecommendedMapper,
                                LocalnewsRecommendedMapper localnewsRecommendedMapper,
                                NewsSyncIntegrationService newsSyncIntegrationService) {
        super(0.1d, 2);
        this.newsMapper = newsMapper;
        this.redisListAdapter = redisListAdapter;
        this.newsRecommendedMapper = newsRecommendedMapper;
        this.localnewsRecommendedMapper = localnewsRecommendedMapper;
        this.newsSyncIntegrationService = newsSyncIntegrationService;
    }

    @Override
    protected List<Long> syncRecommendNews(Long userId, Integer kindId, Integer num, String areaCode) {
        if (StringUtils.isEmpty(areaCode) || StringUtils.isBlank(areaCode)) {
            return new ArrayList<>();
        }
        Long province = Long.valueOf(areaCode.substring(0, 2));
        if (province!=33 && province !=34) {
            return new ArrayList<>();
        }
        if (kindId != null) {
            // 本地新闻
            if (StringUtils.isNotBlank(areaCode) && kindId.intValue() == NewsKindEnum.LOCAL.getCode().intValue()) {

                return localnewsRecommendedMapper.recommendLocalnews(userId, areaCode,province, num);
            }
            // 其他
            return new ArrayList<>();
        } else {
            // 首页本地推荐
            return localnewsRecommendedMapper.recommendLocalnewsOfIndex(userId, areaCode,province, num);
        }
    }

    @Override
    protected void asyncRecommendNews(Long userId, Integer kindId, String areaCode) {

    }
}
