package com.bxm.newidea.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.recommend.RecommendEngine;
import com.bxm.newidea.service.RecommendService;
import com.bxm.newidea.vo.News;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Service
public class RecommendServiceImpl implements RecommendService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private RecommendEngine recommendEngine;

    private NewsMapper newsMapper;

    @Autowired(required = false)
    public RecommendServiceImpl(NewsMapper newsMapper, RecommendEngine recommendEngine){
        this.newsMapper =newsMapper;
        this.recommendEngine = recommendEngine;
    }

    /**
     * 新闻推荐
     * @param userId 用户id
     * @param kindId 频道id 本地新闻时 频道id为-1
     * @param pageSize 本次获取新闻数量
     * @param areaCode 地区编码 参照国标 本地新闻时特有
     * @return 新闻列表
     */
    @Override
    public List<Long> recommend(Long userId, Integer kindId, Integer pageSize, String areaCode,Integer curPage) {
        return recommendEngine.recommendNews(userId,kindId,pageSize,areaCode,curPage);
    }

    
    /**
     * 小视频推荐
     * @param userId 用户id
     * @param pageSize 本次获取小视频数量
     * @return 小视频列表
     */
    @Override
    public List<VideoDto> recommend( Long userId,Integer pageSize) {
        logger.info("Video recommend->userId:{},pageSize:{}",userId,pageSize);
        return recommendEngine.recommendVideo(userId,pageSize);
    }

    /**
     * 新闻详情页内容推荐
     * @param userId 用户id
     * @param newsId 新闻id
     * @return 新闻id集合
     */
    @Override
    public List<Long> recommendByNewsDetail(Long userId, Long newsId,Integer size) {
        //如果是本地新闻则直接返回空，本地新闻不需要相关推荐
        News localnews = newsMapper.selectByPrimaryKey(newsId);
        if (null != localnews) {
            if (localnews.getAreaDetail()!=null) {
                return new ArrayList<>();
            }
        }
        //调用存储过程,以及制定的篇数获取详情页推荐的文章
        List<News> list = newsMapper.queryRecommendNewsList(newsId, size, userId==null?0:userId);
        logger.debug("短期时效表查找详情推荐：{}", JSON.toJSONString(list));
        if (CollectionUtils.isEmpty(list)) {
            list = newsMapper.queryRecommendNewsListWithoutTime(newsId, size, userId==null?0:userId);
            logger.debug("长期时效表查找详情推荐：{}", JSON.toJSONString(list));
        }

        List<Long> ids = new ArrayList<>();
        list.stream().filter(Objects::nonNull).forEach(news -> ids.add(news.getId()));
        return ids;
    }
}
