/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.NewsRecommendedMapper;
import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.integration.NewsSyncIntegrationService;
import com.bxm.newidea.recommend.AbstractRecommender;
import com.bxm.newidea.vo.News;
import com.google.common.hash.BloomFilter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNewsRecommender
extends AbstractRecommender {
    protected boolean recommended = true;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected RedisListAdapter redisListAdapter;
    protected NewsRecommendedMapper newsRecommendedMapper;
    protected NewsSyncIntegrationService newsSyncIntegrationService;

    public AbstractNewsRecommender(double weight, int sort) {
        super(weight, sort);
    }

    @Override
    public List<Long> recommendNews(Long userId, Integer kindId, Integer num, String areaCode) {
        long begin = System.currentTimeMillis();
        List<Long> newsIds = this.syncRecommendNews(userId, kindId, num, areaCode);
        if (newsIds != null && !newsIds.isEmpty()) {
            KeyGenerator recommendedNewsKey = RedisKeyConstant.NEWS_RECOMMENDED.copy().appendKey((Object)userId);
            this.newsSyncIntegrationService.generateRecommneded(userId, newsIds);
            this.redisListAdapter.rightPush(recommendedNewsKey, (Object[])newsIds.toArray(new Long[0]));
        }
        AbstractNewsRecommender recommender = (AbstractNewsRecommender)SpringContextHolder.getBean(this.getClass());
        recommender.asyncRecommendNews(userId, kindId, areaCode);
        this.logger.info("\u63a8\u8350\u7ed3\u679c\uff1a{},\u7528\u6237\uff1a{}\uff0c \u8017\u65f6\uff1a{}", new Object[]{newsIds == null ? Integer.valueOf(0) : JSONObject.toJSONString(newsIds), userId, System.currentTimeMillis() - begin});
        return newsIds;
    }

    protected abstract List<Long> syncRecommendNews(Long var1, Integer var2, Integer var3, String var4);

    protected abstract void asyncRecommendNews(Long var1, Integer var2, String var3);

    @Override
    public List<VideoDto> recommendVideo(Long user, Integer num) {
        return null;
    }

    protected void recommendedFilter(KeyGenerator keyGenerator, Integer num, BloomFilter<Long> bloomFilter, List<Long> resultList, Long userId) {
        long begin = System.currentTimeMillis();
        List newsList = this.redisListAdapter.leftIndex(keyGenerator, (long)(num - 1), News.class);
        this.logger.info("redis\u62c9\u53d6\u5217\u8868\u8017\u65f6\uff1a{} \u5217\u8868\u957f\uff1a{}", (Object)(System.currentTimeMillis() - begin), (Object)newsList.size());
        if (newsList.isEmpty()) {
            return;
        }
        int flag = 0;
        ArrayList<Long> repeatNewsList = new ArrayList<Long>();
        for (News news : newsList) {
            if (bloomFilter != null && bloomFilter.mightContain((Object)news.getId())) {
                repeatNewsList.add(news.getId());
                ++flag;
                continue;
            }
            resultList.add(news.getId());
        }
        long recommendSize = this.redisListAdapter.size(keyGenerator);
        this.redisListAdapter.leftTrim(keyGenerator, (long)num.intValue(), recommendSize);
        if (flag > 0) {
            this.logger.info("\u5e03\u9686\u8fc7\u6ee4\u5668\u7b5b\u9009\u5df2\u91cd\u590d,\u63a8\u8350\u91cd\u590d\u65b0\u95fb\uff1a{}", (Object)JSON.toJSONString(repeatNewsList));
            this.newsSyncIntegrationService.generateRecommneded(userId, repeatNewsList);
            this.recommendedFilter(keyGenerator, flag, bloomFilter, resultList, userId);
        }
        this.logger.info("bloom\u53bb\u91cd\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - begin));
    }
}

