/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.enums.NewsKindEnum;
import com.bxm.newidea.recommend.AbstractRecommender;
import com.bxm.newidea.recommend.RecommendFilter;
import com.bxm.newidea.recommend.RecommendManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RecommendEngine {
    private Logger logger = LoggerFactory.getLogger(RecommendEngine.class);
    private RecommendFilter recommendFilter;
    private RecommendManager recommendManager;

    @Autowired
    public RecommendEngine(RecommendManager recommendManager, RecommendFilter recommendFilter) {
        this.recommendManager = recommendManager;
        this.recommendFilter = recommendFilter;
    }

    public List<Long> recommendNews(Long userId, Integer kindId, Integer num, String areaCode, Integer curPage) {
        if (kindId != null && kindId.intValue() == NewsKindEnum.LOCAL.getCode().intValue()) {
            return this.recommendLocalNews(userId, kindId, num, areaCode);
        }
        if (kindId == null || kindId.intValue() == NewsKindEnum.RECOMMEND.getCode().intValue()) {
            kindId = null;
            return this.recommendCommonNews(userId, kindId, num, areaCode, curPage);
        }
        return this.recommendAllNews(userId, kindId, num, areaCode, (byte)0);
    }

    private List<Long> recommendAllNews(Long userId, Integer kindId, Integer num, String areaCode, Byte type) {
        List<AbstractRecommender> recommenderWorkers = type == 1 ? this.recommendManager.getCommonNewsRecommenders() : this.recommendManager.getNewsRecommenders();
        Iterator<AbstractRecommender> iterator = recommenderWorkers.iterator();
        List<Long> newsIds = new LinkedList<Long>();
        int recommendNum = 0;
        while (iterator.hasNext()) {
            AbstractRecommender recommender = iterator.next();
            int fetchNum = new BigDecimal(num).multiply(new BigDecimal("" + recommender.getWeight())).intValue();
            if (num - recommendNum < fetchNum) {
                fetchNum = num - recommendNum;
            }
            this.logger.debug("{} \u9884\u8ba1\u63a8\u8350\u6570\u91cf\uff1a{} \u7528\u6237\uff1a{}", new Object[]{recommender.getClass(), fetchNum, userId});
            List<Long> results = recommender.recommendNews(userId, kindId, fetchNum, areaCode);
            this.logger.debug("{} \u5b9e\u9645\u63a8\u8350\u6570\u91cf\uff1a{} \u7528\u6237\uff1a{}", new Object[]{recommender.getClass(), results.size(), userId});
            recommendNum += results.size();
            newsIds.addAll(results);
            if (newsIds.size() < num) continue;
            break;
        }
        newsIds = this.recommendFilter.newsFilter(newsIds);
        this.removeDuplicateNews(newsIds);
        return newsIds.size() > num ? newsIds.subList(0, num) : newsIds;
    }

    private List<Long> recommendCommonNews(Long userId, Integer kindId, Integer num, String areaCode, Integer curPage) {
        List<Integer> kindList;
        List<Long> localNewsIds = this.getRecLocalnews(userId, kindId, 3, areaCode);
        this.logger.info("\u63a8\u8350\u5f15\u64ce->\u672c\u5730:{},\u7528\u6237:{}", (Object)JSON.toJSONString(localNewsIds), (Object)userId);
        LinkedList<Object> commonNewsIds = new LinkedList<Object>();
        List<Object> hotNewsIdList = new ArrayList();
        if (curPage == 1) {
            hotNewsIdList = this.recommendHotNews(userId, kindId, 1, areaCode);
            this.logger.info("\u63a8\u8350\u5f15\u64ce->\u7b2c\u4e00\u9875\u63a8\u8350\uff0c\u70ed\u95e8:{},\u7528\u6237:{}", CollectionUtils.isEmpty(hotNewsIdList) ? "\u65e0" : hotNewsIdList.get(0), (Object)userId);
            kindList = this.generateHomeKind();
        } else {
            kindList = this.generateKind();
        }
        for (Integer kind : kindList) {
            commonNewsIds.addAll(this.recommendAllNews(userId, kind, 1, areaCode, (byte)1));
        }
        int count = localNewsIds.size();
        int index = 0;
        for (int i = 0; i < count; ++i) {
            if (index > commonNewsIds.size() - 1) {
                commonNewsIds.addLast(localNewsIds.get(i));
                continue;
            }
            commonNewsIds.add(index, localNewsIds.get(i));
            index += 2;
        }
        if (!CollectionUtils.isEmpty(hotNewsIdList)) {
            commonNewsIds.addFirst(hotNewsIdList.get(0));
        }
        int fetchNum = num - commonNewsIds.size() + 5;
        commonNewsIds.addAll(this.recommendAllNews(userId, null, fetchNum, areaCode, (byte)1));
        return commonNewsIds.stream().distinct().limit(num.intValue()).collect(Collectors.toList());
    }

    private List<Long> getRecLocalnews(Long userId, Integer kindId, Integer num, String areaCode) {
        List<Long> localNewsIds = this.recommendLocalNews(userId, kindId, num, areaCode);
        if (localNewsIds.size() < num) {
            int leftNum = num - localNewsIds.size();
            List<Integer> kindIds = this.generateNationalKind();
            for (Integer kind : kindIds) {
                localNewsIds.addAll(this.recommendAllNews(userId, kind, leftNum, areaCode, (byte)1));
                if (localNewsIds.size() >= num) break;
                leftNum = num - localNewsIds.size();
            }
        }
        return localNewsIds;
    }

    private List<Integer> generateKind() {
        ArrayList<Integer> kindList = new ArrayList<Integer>();
        kindList.add(32);
        kindList.add(20);
        kindList.add(18);
        kindList.add(14);
        kindList.add(69);
        kindList.add(27);
        return kindList;
    }

    private List<Integer> generateHomeKind() {
        ArrayList<Integer> kindList = new ArrayList<Integer>();
        kindList.add(69);
        kindList.add(18);
        kindList.add(69);
        kindList.add(27);
        return kindList;
    }

    private List<Integer> generateNationalKind() {
        ArrayList<Integer> kindList = new ArrayList<Integer>();
        kindList.add(18);
        kindList.add(14);
        kindList.add(69);
        kindList.add(27);
        kindList.add(22);
        return kindList;
    }

    private List<Long> recommendLocalNews(Long userId, Integer kindId, Integer num, String areaCode) {
        AbstractRecommender recommender = this.recommendManager.getLocalNewsRecommender();
        this.logger.debug("\u63a8\u8350\u672c\u5730\u65b0\u95fb\u53c2\u6570: userId={}\uff0ckindId={}\uff0cnum={}\uff0careaCode={}", new Object[]{userId, kindId, num, areaCode});
        List<Long> results = recommender.recommendNews(userId, kindId, num, areaCode);
        this.logger.debug("\u63a8\u8350\u672c\u5730\u65b0\u95fb:{} \u63a8\u8350\u7ed3\u679c\uff1a{} \u7528\u6237\uff1a{}", new Object[]{recommender.getClass(), results.size(), userId});
        results = this.recommendFilter.newsFilter(results);
        return results;
    }

    private List<Long> recommendHotNews(Long userId, Integer kindId, Integer num, String areaCode) {
        AbstractRecommender recommender = this.recommendManager.getHotNewsRecommender();
        this.logger.debug("\u63a8\u8350\u70ed\u95e8\u65b0\u95fb\u53c2\u6570: userId={}\uff0ckindId={}\uff0cnum={}\uff0careaCode={}", new Object[]{userId, kindId, num, areaCode});
        List<Long> results = recommender.recommendNews(userId, kindId, num, areaCode);
        this.logger.debug("\u63a8\u8350\u70ed\u95e8\u65b0\u95fb:{} \u63a8\u8350\u7ed3\u679c\uff1a{} \u7528\u6237\uff1a{}", new Object[]{recommender.getClass(), results.size(), userId});
        results = this.recommendFilter.newsFilter(results);
        return results;
    }

    public List<VideoDto> recommendVideo(Long userId, Integer num) {
        List<AbstractRecommender> recommenderWorkers = this.recommendManager.getVideoRecommenders();
        Iterator<AbstractRecommender> iterator = recommenderWorkers.iterator();
        this.logger.debug("\u89c6\u9891\u65b0\u95fb\u63a8\u8350\u5f15\u64ce\u8c03\u7528\u94fe\uff1a{}", recommenderWorkers);
        List<VideoDto> videoDtoList = new LinkedList<VideoDto>();
        int differenceNum = 0;
        while (iterator.hasNext()) {
            AbstractRecommender recommender = iterator.next();
            int fetchNum = new BigDecimal(num).multiply(new BigDecimal(recommender.getWeight())).intValue() + differenceNum;
            List<VideoDto> results = recommender.recommendVideo(userId, fetchNum);
            this.logger.debug("{} \u63a8\u8350\u7ed3\u679c\uff1a{}", recommender.getClass(), (Object)results.size());
            differenceNum = fetchNum - results.size();
            videoDtoList.addAll(results);
            if (videoDtoList.size() != num.intValue()) continue;
            break;
        }
        videoDtoList = this.recommendFilter.videoFilter(videoDtoList);
        return (videoDtoList = this.removeDuplicateVideo(videoDtoList)).size() > num ? videoDtoList.subList(0, num) : videoDtoList;
    }

    private void removeDuplicateNews(List<Long> list) {
        for (int i = 0; i < list.size() - 1; ++i) {
            for (int j = list.size() - 1; j > i; --j) {
                if (!list.get(j).equals(list.get(i))) continue;
                list.remove(j);
            }
        }
    }

    private List<VideoDto> removeDuplicateVideo(List<VideoDto> list) {
        HashSet<VideoDto> h = new HashSet<VideoDto>(list);
        list.clear();
        list.addAll(h);
        return list;
    }
}

