/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.news;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.NewsRecommendedMapper;
import com.bxm.newidea.domain.NewsRecordMapper;
import com.bxm.newidea.recommend.AbstractNewsRecommender;
import com.bxm.newidea.vo.News;
import com.bxm.newidea.vo.NewsRecord;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.model.GenericBooleanPrefDataModel;
import org.apache.mahout.cf.taste.impl.neighborhood.NearestNUserNeighborhood;
import org.apache.mahout.cf.taste.impl.recommender.GenericUserBasedRecommender;
import org.apache.mahout.cf.taste.impl.similarity.LogLikelihoodSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.neighborhood.UserNeighborhood;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CollaborativeNewsRecommender
extends AbstractNewsRecommender {
    private static SoftReference<FastByIDMap<FastIDSet>> cache;
    private NewsRecordMapper newsRecordMapper;

    @Autowired(required=false)
    public CollaborativeNewsRecommender(NewsRecordMapper newsRecordMapper, RedisListAdapter redisListAdapter, NewsRecommendedMapper newsRecommendedMapper) {
        super(0.5, 3);
        this.newsRecordMapper = newsRecordMapper;
        this.redisListAdapter = redisListAdapter;
        this.newsRecommendedMapper = newsRecommendedMapper;
    }

    @Override
    protected List<Long> syncRecommendNews(Long userId, Integer kindId, Integer num, String areaCode) {
        long begin = System.currentTimeMillis();
        if (kindId != null) {
            return new ArrayList<Long>();
        }
        KeyGenerator userCacheKey = RedisKeyConstant.NEWS_COLLABORATIVE_RECOMMEND.copy().appendKey((Object)userId);
        long size = this.redisListAdapter.size(userCacheKey);
        if (size == 0L) {
            return new ArrayList<Long>();
        }
        KeyGenerator recommendedNewsKey = RedisKeyConstant.NEWS_RECOMMENDED.copy();
        recommendedNewsKey.appendKey((Object)userId);
        long recommendedSize = this.redisListAdapter.size(recommendedNewsKey);
        List recommendedNewIds = this.redisListAdapter.leftIndex(recommendedNewsKey, recommendedSize - 1L, Long.class);
        BloomFilter bloomFilter = null;
        if (recommendedNewIds != null && !recommendedNewIds.isEmpty()) {
            bloomFilter = BloomFilter.create((Funnel)Funnels.longFunnel(), (int)recommendedNewIds.size(), (double)1.0E-4);
            for (Long id : recommendedNewIds) {
                bloomFilter.put((Object)id);
            }
        }
        ArrayList<Long> resultList = new ArrayList<Long>();
        this.recommendedFilter(userCacheKey, num, (BloomFilter<Long>)bloomFilter, resultList, userId);
        this.logger.debug("\u540c\u6b65\u63a8\u8350\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - begin));
        return resultList;
    }

    @Override
    protected void asyncRecommendNews(Long userId, Integer kindId, String areaCode) {
        this.logger.debug("\u534f\u540c\u63a8\u8350\u8865\u5145\u6c60");
        long begin = System.currentTimeMillis();
        try {
            if (kindId != null) {
                return;
            }
            KeyGenerator userCacheKey = RedisKeyConstant.NEWS_COLLABORATIVE_RECOMMEND.copy().appendKey((Object)userId);
            int size = this.redisListAdapter.size(userCacheKey).intValue();
            if (size > NewsCacheThresholdConfig.ALARM_CACHE_SIZE) {
                return;
            }
            FastByIDMap<FastIDSet> dataMap = null;
            dataMap = cache == null || cache.get() == null ? this.getCache() : cache.get();
            if (dataMap == null) {
                return;
            }
            GenericBooleanPrefDataModel dataModel = new GenericBooleanPrefDataModel(dataMap);
            LogLikelihoodSimilarity similarity = new LogLikelihoodSimilarity((DataModel)dataModel);
            NearestNUserNeighborhood neighborhood = new NearestNUserNeighborhood(2, (UserSimilarity)similarity, (DataModel)dataModel);
            GenericUserBasedRecommender recommender = new GenericUserBasedRecommender((DataModel)dataModel, (UserNeighborhood)neighborhood, (UserSimilarity)similarity);
            List list = recommender.recommend(userId.longValue(), NewsCacheThresholdConfig.MAX_CACHE_SIZE);
            ArrayList ids = new ArrayList();
            list.forEach(recommendedItem -> {
                News news = new News();
                news.setId(Long.valueOf(recommendedItem.getItemID()));
                ids.add(news);
            });
            Object[] newsDtos = ids.toArray(new News[0]);
            this.redisListAdapter.remove(userCacheKey);
            this.redisListAdapter.rightPush(userCacheKey, newsDtos);
            this.redisListAdapter.expire(userCacheKey, 3600L);
            this.logger.debug("\u7ed9{}\u8fdb\u884c\u534f\u540c\u8fc7\u6ee4\u65b0\u95fb\u63a8\u8350 \u7ed3\u679c\u7ed3\u679c\uff1a{}\u3002\u82b1\u8d39\u65f6\u95f4{}", new Object[]{userId, ids, System.currentTimeMillis() - begin});
        }
        catch (TasteException e) {
            this.logger.error("\u534f\u540c\u8fc7\u6ee4\u63a8\u8350\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }

    private FastByIDMap<FastIDSet> getCache() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -7);
        List userIdList = this.newsRecordMapper.selectAllUser(calendar.getTime());
        if (userIdList.isEmpty()) {
            this.logger.error("\u534f\u540c\u8fc7\u6ee4\u63a8\u8350\u7528\u6237\u6837\u672c\u4e3a\u7a7a\uff0c\u4e2d\u6b62\u6b64\u6b21\u63a8\u8350");
            return null;
        }
        List newsRecordList = this.newsRecordMapper.selectBooleanPrefList(calendar.getTime());
        if (newsRecordList.isEmpty()) {
            this.logger.error("\u534f\u540c\u8fc7\u6ee4\u63a8\u8350\u6570\u636e\u6837\u672c\u4e3a\u7a7a\uff0c\u4e2d\u6b62\u6b64\u6b21\u63a8\u8350");
            return null;
        }
        FastByIDMap dataMap = new FastByIDMap();
        for (Long uid : userIdList) {
            FastIDSet itemIDSet = new FastIDSet();
            for (NewsRecord record : newsRecordList) {
                if (record.getUserId().longValue() != uid.longValue()) continue;
                itemIDSet.add(record.getNewsId().longValue());
            }
            if (itemIDSet.isEmpty()) continue;
            dataMap.put(uid.longValue(), (Object)itemIDSet);
        }
        cache = new SoftReference<FastByIDMap>(dataMap);
        return dataMap;
    }
}

