/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.news;

import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.domain.HotnewsRecommendedMapper;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.domain.NewsRecommendedMapper;
import com.bxm.newidea.integration.NewsSyncIntegrationService;
import com.bxm.newidea.recommend.AbstractNewsRecommender;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HotNewsRecommender
extends AbstractNewsRecommender {
    private NewsMapper newsMapper;
    private HotnewsRecommendedMapper hotnewsRecommendedMapper;

    @Autowired(required=false)
    public HotNewsRecommender(NewsMapper newsMapper, RedisListAdapter redisListAdapter, NewsRecommendedMapper newsRecommendedMapper, HotnewsRecommendedMapper hotnewsRecommendedMapper, NewsSyncIntegrationService newsSyncIntegrationService) {
        super(0.2, 0);
        this.newsMapper = newsMapper;
        this.redisListAdapter = redisListAdapter;
        this.newsRecommendedMapper = newsRecommendedMapper;
        this.hotnewsRecommendedMapper = hotnewsRecommendedMapper;
        this.newsSyncIntegrationService = newsSyncIntegrationService;
    }

    @Override
    protected List<Long> syncRecommendNews(Long userId, Integer kindId, Integer num, String areaCode) {
        if (kindId != null) {
            return new ArrayList<Long>();
        }
        List newsList = this.hotnewsRecommendedMapper.recommendHotNews(num.intValue(), userId, areaCode);
        if (newsList != null && newsList.size() >= 2) {
            newsList = newsList.subList(0, 2);
        }
        return newsList;
    }

    @Override
    protected void asyncRecommendNews(Long userId, Integer kindId, String areaCode) {
    }
}

