/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.news;

import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.domain.LocalnewsRecommendedMapper;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.domain.NewsRecommendedMapper;
import com.bxm.newidea.enums.NewsKindEnum;
import com.bxm.newidea.integration.NewsSyncIntegrationService;
import com.bxm.newidea.recommend.AbstractNewsRecommender;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LocalNewsRecommender
extends AbstractNewsRecommender {
    private NewsMapper newsMapper;
    private LocalnewsRecommendedMapper localnewsRecommendedMapper;

    @Autowired(required=false)
    public LocalNewsRecommender(NewsMapper newsMapper, RedisListAdapter redisListAdapter, NewsRecommendedMapper newsRecommendedMapper, LocalnewsRecommendedMapper localnewsRecommendedMapper, NewsSyncIntegrationService newsSyncIntegrationService) {
        super(0.1, 2);
        this.newsMapper = newsMapper;
        this.redisListAdapter = redisListAdapter;
        this.newsRecommendedMapper = newsRecommendedMapper;
        this.localnewsRecommendedMapper = localnewsRecommendedMapper;
        this.newsSyncIntegrationService = newsSyncIntegrationService;
    }

    @Override
    protected List<Long> syncRecommendNews(Long userId, Integer kindId, Integer num, String areaCode) {
        if (StringUtils.isEmpty((String)areaCode) || StringUtils.isBlank((String)areaCode)) {
            return new ArrayList<Long>();
        }
        Long province = Long.valueOf(areaCode.substring(0, 2));
        if (province != 33L && province != 34L) {
            return new ArrayList<Long>();
        }
        if (kindId != null) {
            if (StringUtils.isNotBlank((String)areaCode) && kindId.intValue() == NewsKindEnum.LOCAL.getCode().intValue()) {
                return this.localnewsRecommendedMapper.recommendLocalnews(userId, areaCode, province, num);
            }
            return new ArrayList<Long>();
        }
        return this.localnewsRecommendedMapper.recommendLocalnewsOfIndex(userId, areaCode, province, num);
    }

    @Override
    protected void asyncRecommendNews(Long userId, Integer kindId, String areaCode) {
    }
}

