/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.news;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.LocalNewsKindIdConstant;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.domain.NewsRecommendedMapper;
import com.bxm.newidea.integration.NewsSyncIntegrationService;
import com.bxm.newidea.param.NewsRecommendParam;
import com.bxm.newidea.recommend.AbstractNewsRecommender;
import com.bxm.newidea.service.WeightService;
import com.bxm.newidea.vo.News;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class OldMysqlNewsRecommender
extends AbstractNewsRecommender {
    private NewsMapper newsMapper;
    private WeightService weightService;

    @Autowired(required=false)
    public OldMysqlNewsRecommender(NewsRecommendedMapper newsRecommendedMapper, RedisListAdapter redisListAdapter, NewsMapper newsMapper, WeightService weightService, NewsSyncIntegrationService newsSyncIntegrationService) {
        super(1.0, 4);
        this.newsRecommendedMapper = newsRecommendedMapper;
        this.redisListAdapter = redisListAdapter;
        this.newsMapper = newsMapper;
        this.weightService = weightService;
        this.newsSyncIntegrationService = newsSyncIntegrationService;
    }

    @Override
    protected List<Long> syncRecommendNews(Long userId, Integer kindId, Integer num, String areaCode) {
        long begin = System.currentTimeMillis();
        KeyGenerator userCacheKey = RedisKeyConstant.NEWS_RECOMMEND.copy();
        if (kindId != null) {
            userCacheKey.setKey(String.valueOf(kindId));
        }
        userCacheKey.appendKey((Object)userId);
        long size = this.redisListAdapter.size(userCacheKey);
        if (size == 0L) {
            return new ArrayList<Long>();
        }
        KeyGenerator recommendedNewsKey = RedisKeyConstant.NEWS_RECOMMENDED.copy();
        recommendedNewsKey.appendKey((Object)userId);
        long recommendedSize = this.redisListAdapter.size(recommendedNewsKey);
        List recommendedNewIds = this.redisListAdapter.leftIndex(recommendedNewsKey, recommendedSize - 1L, Long.class);
        BloomFilter bloomFilter = null;
        if (recommendedNewIds != null && !recommendedNewIds.isEmpty()) {
            bloomFilter = BloomFilter.create((Funnel)Funnels.longFunnel(), (int)recommendedNewIds.size(), (double)1.0E-4);
            for (Long id : recommendedNewIds) {
                bloomFilter.put((Object)id);
            }
        }
        ArrayList<Long> resultList = new ArrayList<Long>();
        this.recommendedFilter(userCacheKey, num, (BloomFilter<Long>)bloomFilter, resultList, userId);
        this.logger.debug("\u540c\u6b65\u63a8\u8350\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - begin));
        return resultList;
    }

    @Override
    @Async
    protected void asyncRecommendNews(Long userId, Integer kindId, String areaCode) {
        this.logger.info("\u5f02\u6b65\u63a8\u8350\uff0c\u7528\u6237\uff1a{}\uff0c\u9891\u9053\uff1a{}\uff0c\u5730\u533a\uff1a{}", new Object[]{userId, kindId, areaCode});
        long current = System.currentTimeMillis();
        NewsRecommendParam newsRecommendParam = new NewsRecommendParam();
        KeyGenerator userCacheKey = RedisKeyConstant.NEWS_RECOMMEND.copy();
        if (kindId != null) {
            userCacheKey.setKey(String.valueOf(kindId));
            newsRecommendParam.setKindId(Long.valueOf(kindId.intValue()));
            if (kindId.intValue() == LocalNewsKindIdConstant.LOCAL_NEWS.intValue()) {
                userCacheKey.appendKey((Object)areaCode);
                newsRecommendParam.setKindId(null);
                newsRecommendParam.setAreaCode(areaCode);
            }
        }
        userCacheKey.appendKey((Object)userId);
        int size = this.redisListAdapter.size(userCacheKey).intValue();
        if (size > NewsCacheThresholdConfig.ALARM_CACHE_SIZE) {
            return;
        }
        long currentRecalcu = System.currentTimeMillis();
        this.weightService.recalcu(userId);
        this.logger.debug("\u7ed9{}\u8fdb\u884c\u7528\u6237\u6807\u7b7e\u91cd\u7f6e \u82b1\u8d39\u65f6\u95f4{}", (Object)userId, (Object)(System.currentTimeMillis() - currentRecalcu));
        newsRecommendParam.setIsHot(Integer.valueOf(1));
        newsRecommendParam.setUserId(userId);
        newsRecommendParam.setPagesize(Integer.valueOf(NewsCacheThresholdConfig.MAX_CACHE_SIZE));
        List result = this.newsMapper.recommendNews(newsRecommendParam);
        if (result.size() < NewsCacheThresholdConfig.ALARM_CACHE_SIZE) {
            result = this.newsMapper.recommendNewsWithoutTime(newsRecommendParam);
            this.logger.info("\u7531\u4e8e\u65b0\u95fb\u65f6\u6548\u6027\u5bfc\u81f4\u63a8\u8350\u8fc7\u5c11,\u6240\u4ee5\u91cd\u65b0\u8fdb\u884c\u4e00\u6b21\u63a8\u8350,\u53c2\u6570\uff1a{}\uff0c\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)newsRecommendParam), (Object)result.size());
        }
        Object[] newsDtos = result.toArray(new News[0]);
        this.redisListAdapter.remove(userCacheKey);
        this.redisListAdapter.rightPush(userCacheKey, newsDtos);
        this.redisListAdapter.expire(userCacheKey, 3600L);
        this.logger.info("\u7ed9{}\u8fdb\u884c\u9891\u9053\u4e3a{}\u7684\u65b0\u95fb\u63a8\u8350 \u7ed3\u679c\uff1a{}\u3002\u82b1\u8d39\u65f6\u95f4{}", new Object[]{userId, kindId == null ? "\u63a8\u8350" : kindId, newsDtos.length, System.currentTimeMillis() - current});
    }
}

