/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.video;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.VideoMapper;
import com.bxm.newidea.domain.VideoRecommendMapper;
import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.recommend.AbstractVideoRecommender;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class OldMysqlVideoRecommender
extends AbstractVideoRecommender {
    private Logger logger = LoggerFactory.getLogger(OldMysqlVideoRecommender.class);
    private VideoMapper videoMapper;

    @Autowired(required=false)
    public OldMysqlVideoRecommender(RedisListAdapter redisListAdapter, VideoRecommendMapper videoRecommendMapper, VideoMapper videoMapper) {
        super(1.0, 0);
        this.redisListAdapter = redisListAdapter;
        this.videoRecommendMapper = videoRecommendMapper;
        this.videoMapper = videoMapper;
    }

    @Override
    protected List<VideoDto> syncRecommendVideo(Long userId, Integer num) {
        long begin = System.currentTimeMillis();
        KeyGenerator userCacheKey = RedisKeyConstant.VIDEO_RECOMMEND.copy().appendKey((Object)userId);
        List result = this.redisListAdapter.leftIndex(userCacheKey, (long)(num - 1), VideoDto.class);
        if (result.isEmpty()) {
            return result;
        }
        KeyGenerator recommendedNewsKey = RedisKeyConstant.VIDEO_RECOMMENDED.copy();
        recommendedNewsKey.appendKey((Object)userId);
        long recommendedSize = this.redisListAdapter.size(recommendedNewsKey);
        List recommendedIds = this.redisListAdapter.leftIndex(recommendedNewsKey, recommendedSize - 1L, Long.class);
        BloomFilter bloomFilter = null;
        if (recommendedIds != null && !recommendedIds.isEmpty()) {
            bloomFilter = BloomFilter.create((Funnel)Funnels.longFunnel(), (int)recommendedIds.size(), (double)1.0E-4);
            for (Long id : recommendedIds) {
                bloomFilter.put((Object)id);
            }
        }
        ArrayList<VideoDto> resultList = new ArrayList<VideoDto>();
        this.recommend(userCacheKey, num, (BloomFilter<Long>)bloomFilter, resultList);
        this.logger.debug("\u540c\u6b65\u63a8\u8350\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - begin));
        return resultList;
    }

    private void recommend(KeyGenerator keyGenerator, Integer num, BloomFilter<Long> bloomFilter, List<VideoDto> resultList) {
        long begin = System.currentTimeMillis();
        List videoList = this.redisListAdapter.leftIndex(keyGenerator, (long)(num - 1), VideoDto.class);
        this.logger.info("redis\u62c9\u53d6\u5217\u8868\u8017\u65f6\uff1a{} \u5217\u8868\u957f\uff1a{}", (Object)(System.currentTimeMillis() - begin), (Object)videoList.size());
        if (videoList.isEmpty()) {
            return;
        }
        int flag = 0;
        for (VideoDto videoDto : videoList) {
            if (bloomFilter != null && bloomFilter.mightContain((Object)videoDto.getId())) {
                ++flag;
                continue;
            }
            resultList.add(videoDto);
        }
        long recommendSize = this.redisListAdapter.size(keyGenerator);
        this.redisListAdapter.leftTrim(keyGenerator, (long)num.intValue(), recommendSize);
        if (flag > 0) {
            this.recommend(keyGenerator, flag, bloomFilter, resultList);
        }
        this.logger.info("bloom\u53bb\u91cd\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - begin));
    }

    @Override
    @Async
    protected void asyncRecommendVideo(Long userId) {
        long begin = System.currentTimeMillis();
        KeyGenerator userCacheKey = RedisKeyConstant.VIDEO_RECOMMEND.copy().appendKey((Object)userId);
        int size = this.redisListAdapter.size(userCacheKey).intValue();
        if (size > NewsCacheThresholdConfig.ALARM_CACHE_SIZE) {
            return;
        }
        List result = this.videoMapper.getUserRecommend(userId, Integer.valueOf(NewsCacheThresholdConfig.MAX_CACHE_SIZE));
        Object[] videoDtos = result.toArray(new VideoDto[0]);
        this.redisListAdapter.remove(userCacheKey);
        this.redisListAdapter.rightPush(userCacheKey, videoDtos);
        this.redisListAdapter.expire(userCacheKey, 1800L);
        this.logger.debug("\u7ed9[{}]\u8fdb\u884c\u5c0f\u89c6\u9891\u63a8\u8350\u3002\u82b1\u8d39\u65f6\u95f4[{}]", (Object)userId, (Object)(System.currentTimeMillis() - begin));
    }
}

