/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.recommend.RecommendEngine;
import com.bxm.newidea.service.RecommendService;
import com.bxm.newidea.vo.News;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RecommendServiceImpl
implements RecommendService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RecommendEngine recommendEngine;
    private NewsMapper newsMapper;

    @Autowired(required=false)
    public RecommendServiceImpl(NewsMapper newsMapper, RecommendEngine recommendEngine) {
        this.newsMapper = newsMapper;
        this.recommendEngine = recommendEngine;
    }

    @Override
    public List<Long> recommend(Long userId, Integer kindId, Integer pageSize, String areaCode, Integer curPage) {
        return this.recommendEngine.recommendNews(userId, kindId, pageSize, areaCode, curPage);
    }

    @Override
    public List<VideoDto> recommend(Long userId, Integer pageSize) {
        this.logger.info("Video recommend->userId:{},pageSize:{}", (Object)userId, (Object)pageSize);
        return this.recommendEngine.recommendVideo(userId, pageSize);
    }

    @Override
    public List<Long> recommendByNewsDetail(Long userId, Long newsId, Integer size) {
        News localnews = this.newsMapper.selectByPrimaryKey(newsId);
        if (null != localnews && localnews.getAreaDetail() != null) {
            return new ArrayList<Long>();
        }
        List list = this.newsMapper.queryRecommendNewsList(newsId, size.intValue(), Long.valueOf(userId == null ? 0L : userId));
        this.logger.debug("\u77ed\u671f\u65f6\u6548\u8868\u67e5\u627e\u8be6\u60c5\u63a8\u8350\uff1a{}", (Object)JSON.toJSONString((Object)list));
        if (CollectionUtils.isEmpty((Collection)list)) {
            list = this.newsMapper.queryRecommendNewsListWithoutTime(newsId, size.intValue(), Long.valueOf(userId == null ? 0L : userId));
            this.logger.debug("\u957f\u671f\u65f6\u6548\u8868\u67e5\u627e\u8be6\u60c5\u63a8\u8350\uff1a{}", (Object)JSON.toJSONString((Object)list));
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        list.stream().filter(Objects::nonNull).forEach(news -> ids.add(news.getId()));
        return ids;
    }
}

